#ifndef MISC_H
#define MISC_H

/**
 * @file misc.h
 * @author Luca Favario
 * @date Sep 2021
 * @brief Functions without another place to stay
 */

#include "common.h"

/** 
 * @brief Compute the factor which allows to convert pixels to millimeters.
 * The factor corresponds to the width of one pixel on the band tape.
 * The function also calculates the number of white bands (peaks) which is used
 * to compute deltath.
 * Note: this function should be run once at the startup and the result stored
 * to be used in the main loop.
 * @param vect Image floating point vector
 * @param fact Pointer used to return the conversion factor
 * @param peakcount Pointer used to return the number of peaks (white bands)
 * @return 0 in case of success, 1 in case of error.
 */
int pixel_to_mm_factor(float * vect, float * fact, unsigned int * peakcount);

/**
 * @brief Compare the frame vector with a threshold and substitute the smaller
 * elements with 0. 
 * This method allows to reduce the effect of the non-ideal black bands (they
 * are not zero) when computing the cross correlation.
 * @param vect Frame vector to compare and edit.
 */
void threshold_apply(float * vect);
#endif
