#ifndef CONFIG_H
#define CONFIG_H

/**
 * @file config.h
 * @author Luca Favario
 * @date Sep 2021
 * @brief Config file
 */

/******************************
 *           FFT              * 
 ******************************/
/**
 * @def UPS
 * @brief Upscaling used by the algorithm. 
 */
#define UPS 256

/**
 * @def WISDOM
 * @brief path of the FFTW wisdom file. Note that "_RESX_RESY_ZPUPS.txt" will
 * be appended to the file name.
 */
#define WISDOM "./wisdom"

/******************************
 *          CAMERA            * 
 ******************************/
/**
 * @def DEVICE
 * @brief Video device path
 */
#define DEVICE "/dev/video0"

/**
 * @def FORMAT 
 * @brief Video device pixel format (YUYV/MJPEG) 
 * Refer to v4l2-ctl for available formats and resolution: 
 * v4l2-ctl -d /dev/video0 --list-formats-ext 
 */
#define FORMAT MJPEG

/**
 * @def RESX
 * @brief Camera horizontal resolution
 */
#define RESX 640

/**
 * @def RESY
 * @brief Camera vertical resolution
 */
#define RESY 480

/**
 * @def THREAD
 * @brief When defined enable the thread used to refresh the camera buffers, 
 * decompress the images (in case of MJPEG) and compute the sum of the columns.
 */
//#define THREAD

/******************************
 *          SENSOR            * 
 ******************************/

/**
 * @def STDOUT
 * @brief When defined the displacement is written to stdout
 */
#define STDOUT

/**
 * @def SERIAL
 * @brief When defined the displacement is written to serial uart 
 */
//#define SERIAL

/******************************
 *          SERIAL            * 
 ******************************/
/**
 * @def SERIALDEV
 * @brief UART device to be used to write the displacement when SERIAL is set.
 */
#define SERIALDEV "/dev/serial0"

/**
 * @def SERIALSPEED
 * @brief UART device speed
 * Allowed speeds are:
 * B50 B75 B110 B134 B150 B200 B300 B600 B1200 B1800 B2400 B4800 B9600
 * B19200 B38400 B57600 B115200 B230400
 */
#define SERIALSPEED B115200

/**
 * @def SERIALFORMAT
 * @brief Format for the data written to UART, can be RAW or CHAR
 * CHAR: write to serial a string of chars which represent the data, terminated
 * by '\n\r'
 * RAW: write the raw bytes representing the data
 */
#define SERIALFORMAT RAW

/******************************
 *     PIXEL TO MM            * 
 ******************************/
/**
 * @def TRIPLETWIDTH 
 * @brief Width of one triplet as defined in the postscript file.
 * The default value is 3.75 which is multiplied by a factor to scale the bands.
 * Common factors are 0.5 and 0.25 (half and one quarter of the initial width
 * respectively.
 * The band width should be chosen in such way that there is always one full
 * triplet in the captured frames, which allows to compute the pixel to
 * millimeters conversion and to provide the program enough information to
 * compute the displacement.
 */
#define TRIPLETWIDTH 3.75*0.5

/**
 * @def PIXTOMMOUT
 * @brief When defined the output is returned in millimeters. Undefine if the
 * result is required in pixels or if the working conditions are not met. 
 * The conversion works only if there is at least one triplet in the frame and
 * if lighting is nice and flat on the whole frame. 
 * If the peaks do not have the same height or have different rise/fall
 * transitions (bad lighting or bad print quality) then this method will
 * provide incorrect results. 
 * If these conditions are not met then the manual calibration method can be
 * used to convert pixels to mm, defining the macro PIXTOMMCAL.
 * PIXTOMMOUT disables PIXTOMMCAL and fails if it is not able to evaluate the
 * conversion factor.
 */
//#define PIXTOMMOUT

/**
 * @def PIXTOMMCAL
 * @brief Factor used to convert pixels to millimeters manually.
 * Set PIXTOMMCAL to the length on the band which corresponds to one pixel of
 * the frame (obtained dividing the expected millimeters displacement by the
 * obtained pixel one).
 * To use this method PIXTOMMOUT should not be defined.
 */
//#define PIXTOMMCAL 0.08310249
//#define PIXTOMMCAL 0.00396531093
//#define PIXTOMMCAL 0.00393731789

#endif
