#ifndef CAMERA_H
#define CAMERA_H

/**
 * @file camera_file.h
 * @author Luca Favario
 * @date Aug 2021
 * @brief Simulate a camera module with a camera port and DMA. Read the frames
 * from a named pipe.
 */

#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include "common.h"

/** 
 * @brief Dummy dev struct to maintain compatibility with camera.h
 */
struct camera_dev_t {};

/** 
 * @brief Create the FIFO used to transfer the frames
 * @param unused
 * @return 0 if successful, negative in case of error
 */
int camera_init(struct camera_dev_t *unused);

/**
 * @brief Open the FIFO in read mode
 * @param unused
 * @return 0 if success, negative if error
 */
int camera_start(struct camera_dev_t *unused);

/**
 * @brief Close the FIFO
 * @param unused
 * @return 0 if success, negative if error
 */
void camera_stop(struct camera_dev_t *unused);

/**
 * @brief Unused, maintain compatibility
 * @param unused
 * @return 0 if success, negative if error
 */
void camera_close(struct camera_dev_t *unused);

/**
 * @brief Get the frame from FIFO. Bytes are read in blocks of FILEBUFSIZE and
 * the sum of the columns is computed while reading from FIFO without waiting
 * for the whole frame to be available in memory.
 * @param unused
 * @param vectptr pointer to sum of the columns vector
 * @return 0 if success, negative if error
 */
int camera_get_frame(struct camera_dev_t *unused, float **vectptr);

#endif
