#ifndef BENCHMARK_H
#define BENCHMARK_H

/**
 * @file benchmark.h
 * @author Luca Favario
 * @date Aug 2021
 * @brief Limits the number of iterations of the main loop to BENCHN and print
 * the timing information in easy to manipulate files. At the end of the log
 * file average and max timing values are written.
 */

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <errno.h>
#include <sys/time.h>
#include "common.h"

/**
 * @brief Open the benchmark file wich is located in
 * BENCHDIR/bench_RESXxRESY_ZPUPS_UPS.
 * @return 0 if success, 1 if failure
 */
int bench_open();

/**
 * @brief Compute the max value and the average value for each field and write
 * it at the end of the file, then close the file.
 * @return 0 if success, 1 if failure
 */
int bench_close();

/**
 * @brief Start the logging 
 * @return 0 if success, 1 if failure
 */
void bench_start();

/**
 * @brief Stop the logging 
 * @return 0 if success, 1 if failure
 */
void bench_stop();

/**
 * @brief Store the start time of the timer used by the write functions
 */
void bench_start_time();

/**
 * @brief Stop the stop time of the timer used by the write functions
 */
void bench_stop_time();

/**
 * @brief Write timing information about the jpeg decompress process.
 * @param start Start timer
 * @param stop Stop timer
 * @return 0 if success, 1 if failure
 */
int bench_write_decompress();

/**
 * @brief Write timing information about the sum of columns
 * @param start Start timer
 * @param stop Stop timer
 * @return 0 if success, 1 if failure
 */
int bench_write_sum();

/**
 * @brief Write timing information about the computation of the FFT/DFT
 * @param start Start timer
 * @param stop Stop timer
 * @return 0 if success, 1 if failure
 */
int bench_write_computation();

#endif
