#!/bin/bash
RESLIST="640x480 800x600 1280x960 1600x1200 2048x1536"
UPSLIST="2 4 8 16 32 64 128 256"
ZPUPSLIST="1 2"
PLOTDIR="/tmp/"
PLOTNAME="plot_win_zp"
RUNLOG="runtime_win_zp"
BENCHDIR="/tmp/"
CDIR="./src"

echo -n "" > ${PLOTDIR}/${RUNLOG}

COUNT=0
NRES=$(echo $RESLIST | wc -w)
NUPS=$(echo $UPSLIST | wc -w)
NZP=$(echo $ZPUPSLIST | wc -w)
NTOT=$(expr $NZP \* $NRES \* $NUPS)

cd ${CDIR}

for z in ${ZPUPSLIST[@]}
do

	ZPUPS=${z}

	for u in ${UPSLIST[@]}
	do 
		
		echo -n "" > ${PLOTDIR}/${PLOTNAME}_avg_${ZPUPS}_$u
		echo -n "" > ${PLOTDIR}/${PLOTNAME}_max_${ZPUPS}_$u

		for r in ${RESLIST[@]}
		do
			RESX=$(echo $r | sed 's/x.*//')
			RESY=$(echo $r | sed 's/.*x//')

			echo "Progress: ${COUNT}/${NTOT}    ${RESX}x${RESY} UPS=${u} ZPUPS=${ZPUPS}"

			RESX=$RESX RESY=$RESY UPS=$u ZPUPS=$ZPUPS make bench > /dev/null 2>&1

			if [[ "$1" == "--double" ]] && [[ "$1" == "-d" ]] 
			then
				# Run once to update fftw wisdom 
				./sensor_bench > /dev/null 2>&1	
			fi

			# Run to get the correct plan preparation time
			EXETIME=$( TIMEFORMAT='%R' ; time (./sensor_bench > /dev/null 2>&1) 2>&1 1>/dev/null)
			echo "${RESX} ${RESY} $ZUPUS ${u} $EXETIME" >> ${PLOTDIR}/${RUNLOG}

			if [ -f "${BENCHDIR}/bench_${RESX}x${RESY}_${ZPUPS}_${u}" ]
			then
				echo -n "$RESX $RESY " >> ${PLOTDIR}/${PLOTNAME}_avg_${ZPUPS}_${u}
				grep Average ${BENCHDIR}/bench_${RESX}x${RESY}_${ZPUPS}_${u} | sed 's/Average:[ ]*//' >> ${PLOTDIR}/${PLOTNAME}_avg_${ZPUPS}_${u}
				echo -n "$RESX $RESY " >> ${PLOTDIR}/${PLOTNAME}_max_${ZPUPS}_${u}
				grep Max ${BENCHDIR}/bench_${RESX}x${RESY}_${ZPUPS}_${u} | sed 's/Max:[ ]*//' >> ${PLOTDIR}/${PLOTNAME}_max_${ZPUPS}_${u}
			else
				echo -n "$RESX $RESY " >> ${PLOTDIR}/${PLOTNAME}_avg_${ZPUPS}_${u}
				echo "-1 -1 -1 -1" >> ${PLOTDIR}/${PLOTNAME}_avg_${ZPUPS}_${u}
				echo -n "$RESX $RESY " >> ${PLOTDIR}/${PLOTNAME}_max_${ZPUPS}_${u}
				echo "-1 -1 -1 -1" >> ${PLOTDIR}/${PLOTNAME}_max_${ZPUPS}_${u}
			fi

			COUNT=$(expr $COUNT + 1)
		done

	done

done

cd -
