import stat, os, re, time
"""
This program is used to read the frames in framespath (frame_XXXX.pgm, with
XXXX number on 4 digits) and write them to the sensor_file program using the
named pipe defined with fifopath.
The files are sent in blocks of bufsize bytes.
"""
# Named pipe name
fifopath = "/tmp/fifopipe"

# Directory containing the frames
framespath = "./frames"

# Size of the block of bytes to be sent at each iteration, be sure that this
# size match for this program and sensor_file.
# If -1 then the size is equal to the image horizontal resolution resx.
bufsize = -1

def main():
    
    # Create the named pipe
    try:
        os.mkfifo(fifopath)
    except FileExistsError:
        pass

    # Flag to break the file loop
    flag = 1

    # Flag first iteration
    first = 1

    # Open writing end of the FIFO
    with open(fifopath, 'wb') as fifo:

        global bufsize
        
        # List the files in framespath and keep in the list only the ones with
        # name frameXXXX.pgm, with X the frame number on 4 digits. Sort the list
        # in alphabetical order to start from frame 1
        frameslist = os.listdir(framespath)
        frameslist = [ filename for filename in frameslist if re.search('^frame_[0-9]+\.pgm', filename) ]
        frameslist.sort()

        # Iterate the valid frame files
        for filename in frameslist:

            # Open the frame
            with open(framespath+"/"+filename, 'rb') as framefile:

                # Extract the frame size from the pgm header
                _unused = framefile.readline()
                if first == 1:
                    tmp = framefile.readline().split()
                    resx = int(tmp[0])
                    resy = int(tmp[1])
                    print("Resolution: ", resx, "x", resy)
                    if bufsize == -1:
                        bufsize = resx
                    first = 0
                else:
                    _unused = framefile.readline()
                _unused = framefile.readline()

                print(filename, "... ", end="")

                # Read the whole frame from file file and write it to the
                # pipe one pixel at a time (yes, it is slow)
                frame = framefile.read(resx*resy)
                
                # For each byte in the frame
                i = 0
                while i < resx*resy:
                #for i in frame:
                    
                    try:
                        #fifo.write(i.to_bytes(1, 'big'))
                        fifo.write(frame[i:i+bufsize])

                    # Read end is closed
                    except BrokenPipeError:
                        print("Broken pipe")
                        flag = 0
                        break

                    i = i + bufsize

                print("Finished")

            # Break the outer loop if the read end is closed
            if not flag:
                break

    return 0

if __name__ == "__main__":
    main()
