%% Sensitivit all'inerzia del volano

clear all
close all
clc

%% Ciclo for
%nsim = 1 per simulare la risposta di FW e DG separatamente
%decommentare le linee del plot
nsim = 1;

for z = 1:1:nsim
%% Parametri dell'ABB (DC motor DMR 180 SN)
    
    DCmot.Van = 400;
    DCmot.Ra = 0.2;
    DCmot.La = 1.4e-3;
    DCmot.Kt = 1.5;
    DCmot.Ke = DCmot.Kt;
    fess.Jm = 0.4;
    
    % Porre F = 1 per vedere l'effetto del FESS
    % Porre F = 0 per vedere l'effetto del solo DG
    F = 1;
    % Stesso ragionamento per il generatore
    D = 0;
    
    % l'inerzia del volano assume i valori 5-10-15                  %[kg*m^2]
    fess.Jf = 10*z;                                                  %J sens
    J = (fess.Jm + fess.Jf);                                        %inerzia totale [kg*m^2]
    
%% verifica stabilit della risposta
    
    % calcolo delle costanti di tempo del motore DC per verificarne 
    % la stabilit, tau_a < tau_m/4
    
    DCmot.tau_a = DCmot.La/DCmot.Ra;                                %cdt elettrica
    DCmot.tau_m =DCmot.Ra*J/(DCmot.Kt*DCmot.Ke);                    %cdt meccanica
    DCmot.test = DCmot.tau_m - 4*DCmot.tau_a;                       %maggiore di 0?
    
    %porre C = 1 per simulare la dinamica di commutazione
    %porre C = 0 per non simulare la dinamica di commutazione
    
    C = 0;
    DCmot.Tsw = 1/10e3;                                             %10 kHZ
    DCmot.fsw = 1/DCmot.Tsw;


%% Calcolo dei valori di regime

    DCmot.Tn = DCmot.Kt*DCmot.Van/DCmot.Ra;
    DCmot.Tr = DCmot.Tn/6;
    DCmot.I_reg = DCmot.Tr/DCmot.Kt;
    DCmot.T_reg = DCmot.Tr;
    DCmot.w_reg = (DCmot.Van - DCmot.Ra*DCmot.I_reg)/DCmot.Ke;
    DCmot.w_0 = DCmot.Van/DCmot.Ke;
    DCmot.Pmax = DCmot.Van*DCmot.I_reg;
    DCmot.Energy = 0.5 * J * DCmot.w_0^2;


%% Taratura PI

    DCmot.kpi = DCmot.La*2*pi*(DCmot.fsw);
    DCmot.kii = DCmot.kpi*2*pi*(DCmot.fsw/5);
    DCmot.kpw = J*2*pi*(DCmot.fsw/20);
    DCmot.kiw= DCmot.kpw*2*pi*(DCmot.fsw/2000);

%% Generatore Diesel

    f_el = 50;
    DG.kp_dg = 70;                      % 6% DROOP
    DG.ki_dg = 100;                     % ki regolatore DG
    DG.tau_gov = 0.1;                   % ritardo del controllore di velocit
    DG.t0 = 0.05;
    DG.H = 7;                           % costante di inerzia del DG
    DG.D = 0.8;                         % smorzamento DG

%% Input della simulazione
    
    t_step = 5;
    P_load = 1500;                      %entit del carico
    time = 15;                          %durata della simulazione
    
% %% Segnale di carico tramite LUT
% 
%     mod = 8;             %indice di modularit
% 
%     y = [0 P_load P_load 0 -Pload/2 -Pload/2 0];
%     %a = length(y);
%     x = [0 6 8 10 12 14 16];
% %     time = x(length(x))
%     %x = linspace(0, time, a);
% %     plot (x,y)
% %     axis([0 time 1.5*P_load -P_load]);
% %     xlabel('Time [s]');
% %     ylabel('Torque [Nm]');


%% SIM & FIG
    
%     sim('Sensitivity_model');
    sim('mask_subsystem');
% 
%     figure(1)
%     
%     plot(ans.f1, 'LineWidth',1.5)
%      legend ('10 [kg m^2]')
% 
%     hold on
%     
%     plot(ans.f2, 'LineWidth',1.5)
%     legend ('10 [kg m^2]','20 [kg m^2]')
% %     legend ('f with FESS','f without FESS')
%     
%     xlim([4.5 6])
%     ylim([49.2 50.1])
%     
%     xlabel('tempo [s]');
%     ylabel('Frequenza [Hz]');
%     
%     title('andamento della frequenza elettrica nel tempo')
%     grid on
%     
%     hold on 
    
    %State of energy
    figure(2)
    
    plot(ans.Soe1, 'LineWidth',1.5)
%      legend ('Moduli FESS [1]')

%     hold on
%     
%     plot(ans.Soe2, 'LineWidth',1.5)
%     
% %     legend ('Moduli FESS [1]','Moduli FESS [2]')
% 
%     legend ('10 [kg m^2]','20 [kg m^2]')
% %     legend ('f with FESS','f without FESS')
    
    xlim([5 15])
    ylim([4 8])
    
    xlabel('tempo [s]');
    ylabel('Soe [%]');
    
    title('Energia residuaL nel tempo')
    grid on
    
    hold on

end
