%% DIMENSIONAMENTO STRUTTURALE
clear all
close all
clc

s1=43; %mm %spessore asta pistone all'interfaccia con l'albero trasversale ai due bracci del pantografo
L1=0.464; %m %distanza tra i due bracci interni del pantografo
s2=40; %mm %larghezza della sezione rettangolare del tubolare (in base a
%ciò che si otterra in "Dimensionamento_strutturale_3")
L2=0.55; %m %distanza interna tra tubolari esterni
Rp02=650; %MPa %carico di snervamento
CS=1.5; %coefficiente di sicurezza

v=10; %lunghezza vettore x_m

%N.B
%1=ALBERO DI SPINTA PISTONE
%2=CERNIERA INTERNA PANTOGRAFO

%% ALBERO DI SPINTA PISTONE
F_max_t=input('Immettere valore della forza di spinta massima teorica F_max_t ottenuta dal foglio precedente (in Newton): '); %da foglio precedente
%F_max_t=5257.5

s1=s1*10^-3; %m
q=F_max_t/s1;
Ta=F_max_t/2;
Tb=Ta;
Ma=0;
Mb=0;

%Campata1 (0<x<(L1-s1)/2)
%Inizio
x1=0;
Ty1=-Ta;
Mf1=Ta*x1;
%Fine
x2=(L1-s1)/2;
Ty2=Ty1;
Mf2=Ta*x2;
%Campata2 ((L1-s1)/2<x<(L1+s1)/2)
%Inizio
x3=(L1-s1)/2;
Ty3=-Ta+q*(x3-(L1-s1)/2);
Mf3=Ta*x3-q*(x3-(L1-s1)/2)^2/2; %parabolica
%Fine
x4=(L1+s1)/2;
Ty4=-Ta+q*(x4-(L1-s1)/2);
Mf4=Ta*x4-q*(x4-(L1-s1)/2)^2/2; %parabolica
%Punto Massima Altezza
% x_m=L1/2;
% Ty_m=-Ta+q*(x_m-(L1-s1)/2);
% Mf_m=Ta*x_m-q*(x_m-(L1-s1)/2)^2/2; %parabolica
% v=10; %lunghezza vettore x_m
x_m=linspace((L1-s1)/2,(L1+s1)/2,v);
Ty_m=-Ta+q.*(x_m-(L1-s1)/2);
Mf_m=Ta.*x_m-q.*(x_m-(L1-s1)/2).^2/2; %parabolica
%Campata3 ((L1+s1)/2<x<L1)
%Inizio
x5=(L1+s1)/2;
Ty5=-Ta+q*s1;
Mf5=Ta*x5-q*s1*(x5-L1/2);
%Fine
x6=L1;
Ty6=-Ta+q*s1;
Mf6=Ta*x6-q*s1*(x6-L1/2);


%Diagrammi delle sollecitazioni
x_L1=[0,x1,x2,x2,x_m,x4,x4,x6,x6];
Ty_L1=[0,Ty1,Ty2,Ty3,Ty_m,Ty4,Ty5,Ty6,0];
Mf_L1=[0,Mf1,Mf2,Mf3,Mf_m,Mf4,Mf5,Mf6,0];

figure
subplot(2,1,1)
plot(x_L1, Ty_L1,'r')
title('Diagramma degli sforzi albero di spinta pistone')
xlabel('Coordinata longitudinale x [m]')
ylabel('Sforzo tangenziale T_y [N]')
grid on
subplot(2,1,2)
plot(x_L1, Mf_L1,'g')
xlabel('Coordinata longitudinale x [m]')
ylabel('Momento flettente M_z [Nm]')
grid on

%Dai diagrammi risulta che la tensione tangenziale massima Ty la si ha in
%corrispondenza degli incastri. Invece, il momento flettente massimo è in
%corrispondenza del punto in cui il pistone agisce sulla trave (cardine)

%Dimensionamento diametro minimo per trave L1
Mf_max_L1=abs(max(Mf_L1));
Ty_max_L1=abs(max(Ty_L1));
Sig_id_max_V=Rp02/CS; %Von Mises
%Sezione centrale (Mf_L1 massima)
Sig_max_Mf_L1=Sig_id_max_V;
Wd_L1=(Mf_max_L1*10^3)/Sig_max_Mf_L1; %mm^3
d1_L1=(32*Wd_L1/pi)^(1/3); %mm
%Sezione incastrata (Ty_L1 massima)
Tau_max_L1=Sig_id_max_V/sqrt(3);
d2_L1=sqrt((16*Ty_max_L1)/(Tau_max_L1*3*pi)); %mm
d_min_L1=max(d1_L1,d2_L1); %mm %diametro minimo

fprintf('Diametro minimo albero di spinta pistone [mm]= %.1f \n', d_min_L1);


%% CERNIERA INTERNA PANTOGRAFO
Fc_max_t=input('Immettere valore della forza sulla cerniara C Fc_max_t ottenuta dal foglio precedente (in Newton): '); %da foglio precedente
Fc_max_t=Fc_max_t/2;
%Fc_max_t=5554.5/2

s2=s2*10^-3; %m
q=Fc_max_t/s2;
Ta=Fc_max_t;
Tb=Ta;
Ma=0;
Mb=0;

%Campata1 (0<x<s2)
%Inizio
x1=0;
Ty1=-Ta+q*x1;
Mf1=Ta*x1-(q*x1^2)/2; %parabolica
%Fine
x2=s2;
Ty2=-Ta+q*x2;
Mf2=Ta*x2-(q*x2^2)/2; %parabolica
%Intermedio
xm_1=linspace(x1,x2,v);
Tym_1=-Ta+q.*xm_1;
Mfm_1=Ta.*xm_1-(q.*xm_1.^2)/2; %parabolica
%Campata2 (s2<x<L2-s2)
%Inizio
x3=s2;
Ty3=-Ta+q*s2;
Mf3=Ta*x3-q*s2*(x3-s2/2); %parabolica
%Fine
x4=L2-s2;
Ty4=Ty3;
Mf4=Ta*x4-q*s2*(x4-s2/2); %parabolica
% Campata3 (L2-s2<x<L2)
%Inizio
x5=L2-s2;
Ty5=q*(x5-(L2-s2));
Mf5=q*s2^2/2-(q*(x5-(L2-s2))*(x5-(L2-s2)))/2; %parabolica
%Fine
x6=L2;
Ty6=q*(x6-(L2-s2));
Mf6=q*s2^2/2-(q*(x6-(L2-s2))*(x6-(L2-s2)))/2; %parabolica
%Intermedio
xm_2=linspace(x5,x6,v);
Tym_2=q.*(xm_2-(L2-s2));
Mfm_2=q*s2^2/2-(q.*(xm_2-(L2-s2)).*(xm_2-(L2-s2)))/2; %parabolica


%Diagrammi delle sollecitazioni
x_L2=[0,x1,xm_1,x2,x2,x4,x4,xm_2,x6,x6];
Ty_L2=[0,Ty1,Tym_1,Ty2,Ty3,Ty4,Ty5,Tym_2,Ty6,0];
Mf_L2=[0,Mf1,Mfm_1,Mf2,Mf3,Mf4,Mf5,Mfm_2,Mf6,0];

figure
subplot(2,1,1)
plot(x_L2, Ty_L2,'r')
title('Diagramma degli sforzi cerniera interna pantografo')
xlabel('Coordinata longitudinale x [m]')
ylabel('Sforzo tangenziale T_y [N]')
grid on
subplot(2,1,2)
plot(x_L2, Mf_L2,'g')
xlabel('Coordinata longitudinale x [m]')
ylabel('Momento flettente M_z [Nm]')
grid on

%Dai diagrammi risulta che la tensione tangenziale massima Ty la si ha in
%corrispondenza degli incastri. Invece, il momento flettente massimo è in
%corrispondenza del tartto compreso tra i due tubolari interni

%Dimensionamento diametro minimo per trave L1
Mf_max_L2=abs(max(Mf_L2));
Ty_max_L2=abs(max(Ty_L2));
Sig_id_max_V=Rp02/CS; %Von Mises
%Sezione centrale (Mf_L1 massima)
Sig_max_Mf_L2=Sig_id_max_V;
Wd_L2=(Mf_max_L2*10^3)/Sig_max_Mf_L2; %mm^3
d1_L2=(32*Wd_L2/pi)^(1/3); %mm
%Sezione incastrata (Ty_L1 massima)
Tau_max_L2=Sig_id_max_V/sqrt(3);
d2_L2=sqrt((16*Ty_max_L2)/(Tau_max_L2*3*pi)); %mm
d_min_L2=max(d1_L2,d2_L2); %mm %diametro minimo

fprintf('Diametro minimo cerniera interna pantografo [mm]= %.1f \n', d_min_L2);