################################################
##      Filename:     task_tree_item.py      ##
##      Date:         13/05/2020              ##
##      Author:       Ayman HATOUM            ##
################################################
"""This file contains the class definition of taskTreeItem(). A subclass
of QTreeWidgetItem() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QTreeWidgetItem
from src.constants import whatsThisMsg

#----------------------------------------------------------------------------#

class taskTreeItem(QTreeWidgetItem) :
    "Task tree item class"
    def __init__(self, parent, task) :
        logging.getLogger(__name__).debug("Constructing task tree item of {}...".format(task))
        super().__init__(parent, QTreeWidgetItem.UserType + 1)
        
        self.taskData = task
        
        self.setFlags(Qt.ItemIsSelectable | Qt.ItemIsEnabled | Qt.ItemIsDragEnabled | Qt.ItemNeverHasChildren)

        self.setWhatsThis(0, whatsThisMsg.format("Task Name", "Name of child task."))
        self.setWhatsThis(1, whatsThisMsg.format("Task Inputs", "Name and Type of task inputs."))
        self.setWhatsThis(2, whatsThisMsg.format("Task Outputs", "Name and Type of task Outputs."))

    def data(self, column, role) :
        if role == Qt.DisplayRole :
            if column == 0 : 
                return self.taskData.name
            elif column == 1 :
                if self.taskData.inputs :
                    inputs = []
                    for param in self.taskData.inputs :
                        text = "{} ({})".format(param.label, param.type)
                        inputs.append(text)
                    return ", ".join(inputs)
                else : 
                    return ""
            elif column == 2 : 
                if self.taskData.outputs :
                    outputs = []
                    for param in self.taskData.outputs :
                        text = "{} ({})".format(param.label, param.type)
                        outputs.append(text)
                    return ", ".join(outputs)
                else : 
                    return ""
        return QTreeWidgetItem.data(self, column, role)
        
#----------------------------------------------------------------------------#