###############################################
##      Filename:     task_mime_data.py      ##
##      Date:         25/04/2020             ##
##      Author:       Ayman HATOUM           ##
###############################################
"""This file contains the class definition of taskMimeData(). A subclass
of QMimeData() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import QMimeData

#----------------------------------------------------------------------------#

class taskMimeData(QMimeData) :
    "Task mime data class"
    def __init__(self, treeItem) :
        logging.getLogger(__name__).debug("Constructing task mime data of {}...".format(treeItem))
        super().__init__()
        
        self.taskItem = treeItem
        self.formats = ["application/x-qtreewidgetitemtask"]
        
    def formats(self) :
        return self.formats
        
    def retrieveData(self, mimeType, returnType) :
        if mimeType == self.formats[0] :
            return self.taskItem
        return QMimeData.retrieveData(self, mimeType, returnType)
        
#----------------------------------------------------------------------------#