##################################################
##      Filename:     target_tree_item.py      ##
##      Date:         21/04/2020                ##
##      Author:       Ayman HATOUM              ##
##################################################
"""This file contains the class definition of targetTreeItem(). A subclass
of QTreeWidgetItem() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QTreeWidgetItem
from PyQt5.QtGui import QColor
from src.constants import whatsThisMsg
from src.windows.targets.tree.task_tree_item import taskTreeItem

#----------------------------------------------------------------------------#

class targetTreeItem(QTreeWidgetItem) :
    "Target tree item class"
    def __init__(self, target, label, canID, color) :
        logging.getLogger(__name__).debug("Constructing target tree item of {}...".format(target))
        super().__init__(QTreeWidgetItem.UserType)
        
        self.targetData = target
        self.label = label
        self.canID = int(canID)
        self.color = color
        
        self.setFlags(Qt.ItemIsEnabled)
        self.setupTarget()

        self.setWhatsThis(0, whatsThisMsg.format("Target Item", "Describes target's parameters and child tasks. You can modify parameters by <strong>Right Click -> Modify Target</strong>. You can remove target by <strong>Right Click -> Remove Target</strong>."))
                
    def setupTarget(self) :
        font = self.font(0)
        font.setBold(True)
        self.setFont(0, font)
        for task in self.targetData.tasks :
            taskTreeItem(self, task)
    
    def data(self, column, role) :
        if (column == 0 and role == Qt.DecorationRole) :
            return QColor(self.color)
        if (column == 0 and role == Qt.DisplayRole) :
            return self.label+"::"+self.targetData.name+"::ID: "+str(self.canID)
        return QTreeWidgetItem.data(self, column, role)
        
#----------------------------------------------------------------------------#