#################################################
##      Filename:     task_input_class.py      ##
##      Date:         13/05/2020               ##
##      Author:       Ayman HATOUM             ##
#################################################
"""This file contains the class definition of taskInputClass()."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging

#----------------------------------------------------------------------------#

class taskInputClass() :
    "Task input class"
    def __init__(self, data = {}) :
        logging.getLogger(__name__).debug("Constructing task input class...")
        self.setData(data)
        
    def setData(self, data) :
        if data :
            self.label = data["label"]
            self.type = data["type"]
            if self.type == "int" :
                self.default = int(data["default"])
                try :
                    self.min = int(data["min"])
                except KeyError :
                    self.min = None
                try :
                    self.max = int(data["max"])
                except KeyError :
                    self.max = None
            elif self.type == "float" :    
                self.default = float(data["default"])
                try :
                    self.min = float(data["min"])
                except KeyError :
                    self.min = None
                try :
                    self.max = float(data["max"])
                except KeyError :
                    self.max = None
            else :
                self.default = data["default"]
        else :
            self.label = ""
            self.type = ""
            self.default = 0

    def valueValid(self, value) :
        logging.getLogger(__name__).debug("Validating input value [{}]...".format(value))
        errorMessage = "should be {}.".format(self.type)
        if self.type == "int" :
            if type(value) != int :
                return (False, errorMessage)
            if self.min != None :
                if value < self.min :
                    errorMessage = "should be greater than MIN: {}.".format(self.min)
                    return (False, errorMessage)
            if self.max != None :
                if value > self.max :
                    errorMessage = "should be smaller than MAX: {}.".format(self.max)
                    return (False, errorMessage)
        elif self.type == "float" :
            if type(value) != float :
                return (False, errorMessage)
            if self.min :
                if value < self.min :
                    errorMessage = "should be greater than MIN: {}.".format(self.min)
                    return (False, errorMessage)
            if self.max :
                if value > self.max :
                    errorMessage = "should be smaller than MAX: {}.".format(self.max)
                    return (False, errorMessage)
        else :
            if type(value) != bool :
                return (False, errorMessage)
        return (True, "")      

#----------------------------------------------------------------------------#