###########################################
##      Filename:     task_class.py      ##
##      Date:         18/04/2020         ##
##      Author:       Ayman HATOUM       ##
###########################################
"""This file contains the class definition of taskClass()."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from src.windows.targets.task_input_class import taskInputClass
from src.windows.targets.task_output_class import taskOutputClass

#----------------------------------------------------------------------------#

class taskClass() :
    "Task class"
    def __init__(self, data = {}) :
        logging.getLogger(__name__).debug("Constructing task class...")
        self.setData(data)
        
    def setData(self, data) :
        if data :
            self.name = data["name"]
            self.wcet = data["wcet"]
            self.inputs = []
            inputs = data["in"]
            for param in inputs :
                self.inputs.append(taskInputClass(param))
            self.outputs = []
            outputs = data["out"]
            for param in outputs :
                self.outputs.append(taskOutputClass(param))
        else :
            self.name = ""
            self.wcet = None
            self.inputs = []
            self.outputs = []

#----------------------------------------------------------------------------#