#############################################
##      Filename:     target_class.py      ##
##      Date:         18/04/2020           ##
##      Author:       Ayman HATOUM         ##
#############################################
"""This file contains the class definition of targetClass()."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from src.windows.targets.task_class import taskClass

#----------------------------------------------------------------------------#

class targetClass() :
    "Target class"
    def __init__(self, data = {}) :
        logging.getLogger(__name__).debug("Constructing target class...")
        self.setData(data)
        
    def setData(self, data) :
        if data :
            self.name = data["name"]
            self.hw = data["hw"]
            self.sw = data["sw"]
            self.tasks = []
            tasks = data["tasks"]
            for task in tasks :
                self.tasks.append(taskClass(task))
        else :
            self.name = ""
            self.hw = ""
            self.sw = ""
            self.tasks = []

    def hasTask(self, taskName) :
        logging.getLogger(__name__).debug("Checking task '{}' presence in '{}'...".format(taskName, self.name))
        for item in self.tasks :
            if item.name == taskName :
                return item
        return None

#----------------------------------------------------------------------------#