#################################################
##      Filename:     terminal_widget.py       ##
##      Date:         07/07/2020               ##
##      Author:       Ayman HATOUM             ##
#################################################
"""This file contains the class definition of terminalWidget(). A subclass
of QWidget() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
from PyQt5.QtWidgets import QWidget, QVBoxLayout, QLabel, QHBoxLayout, QFrame
from src.windows.prompt.terminal.log_view import logView
# from src.windows.prompt.terminal.cmd_line import cmdLine

#----------------------------------------------------------------------------#

class terminalWidget(QWidget) :
    "Terminal class window"
    def __init__(self, parent) :
        super().__init__(parent)
        
        self.mainWindow = parent

        self.logView = logView(self)
        # self.cmdLine = cmdLine(self)

        self.createLayout()

        # self.cmdLine.cmdInput.connect(self.cmdInput)

    # def cmdInput(self, cmd) :
    #     self.logView.write(">> {}\n".format(cmd))

    def createLayout(self) :
        # self.separator1 = QFrame()
        # self.separator1.setFrameShape(QFrame.HLine)
        # self.separator1.setFrameShadow(QFrame.Sunken)
        self.separator2 = QFrame()
        self.separator2.setFrameShape(QFrame.HLine)
        self.separator2.setFrameShadow(QFrame.Sunken)

        # self.suffixLabel = QLabel(">>")
        # self.suffixLabel.setIndent(3)
        # self.suffixLabel.setStyleSheet("QLabel { background-color : white; font-family : Lucida Console }")

        self.vLayout = QVBoxLayout()
        # self.hLayout = QHBoxLayout()
        # self.hLayout.addWidget(self.suffixLabel)
        # self.hLayout.addWidget(self.cmdLine, 1)
        self.vLayout.addWidget(self.logView, 1)
        # self.vLayout.addWidget(self.separator1)
        # self.vLayout.addLayout(self.hLayout)
        self.vLayout.addWidget(self.separator2)
        self.vLayout.setSpacing(0)
        self.vLayout.setContentsMargins(1, 0, 1, 0)

        self.setLayout(self.vLayout)        
        
#----------------------------------------------------------------------------#