##########################################
##      Filename:     log_view.py       ##
##      Date:         07/07/2020        ##
##      Author:       Ayman HATOUM      ##
##########################################
"""This file contains the class definition of logView(). A subclass
of QPlainTextEdit() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
from PyQt5.QtWidgets import QPlainTextEdit
from PyQt5.QtWidgets import QFrame
from PyQt5.QtGui import QTextCursor

#----------------------------------------------------------------------------#

class logView(QPlainTextEdit) :
    "Log class view"
    def __init__(self, parent) :
        super().__init__(parent)
        
        self.terminal = parent 

        self.setFrameShape(QFrame.NoFrame)
        self.setReadOnly(True)
        self.setLineWrapMode(QPlainTextEdit.NoWrap)

        font = self.font()
        font.setFamily("Lucida Console")
        self.setFont(font)

    def write(self, text) :
        cursor = self.textCursor()
        cursor.movePosition(QTextCursor.End)
        self.setTextCursor(cursor)
        self.insertPlainText(text)
        self.ensureCursorVisible()

    def flush(self) :
        pass
        
#----------------------------------------------------------------------------#