##########################################
##      Filename:     cmd_line.py       ##
##      Date:         07/07/2020        ##
##      Author:       Ayman HATOUM      ##
##########################################
"""This file contains the class definition of cmdLine(). A subclass
of QLineEdit() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
from PyQt5.QtCore import Qt
from PyQt5.QtCore import pyqtSignal
from PyQt5.QtWidgets import QLineEdit

#----------------------------------------------------------------------------#

class cmdLine(QLineEdit) :
    "Cmd line class"
    cmdInput = pyqtSignal(str)
    def __init__(self, parent) :
        super().__init__(parent)
        
        self.terminal = parent

        self.setMaxLength(100)
        self.setFrame(False)

        font = self.font()
        font.setFamily("Lucida Console")
        self.setFont(font)

    def keyPressEvent(self, event) :
        if event.key() == Qt.Key_Return :
            self.cmdInput.emit(self.text())
            self.clear()
        QLineEdit.keyPressEvent(self, event)        

#----------------------------------------------------------------------------#