##############################################
##      Filename:     prompt_window.py      ##
##      Date:         18/04/2020            ##
##      Author:       Ayman HATOUM          ##
##############################################
"""This file contains the class definition of promptWindow(). A subclass
of QDockWidget() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QDockWidget
from src.constants import whatsThisMsg
from src.windows.prompt.terminal.terminal_widget import terminalWidget

#----------------------------------------------------------------------------#

class promptWindow(QDockWidget) :
    "Prompt class window"
    def __init__(self, parent) :
        super().__init__(parent)
        
        self.setWindowTitle("Prompt")
        self.setAllowedAreas(Qt.BottomDockWidgetArea)

        self.terminal = terminalWidget(parent)

        self.setWidget(self.terminal)        

        self.setWhatsThis(whatsThisMsg.format("Prompt Window", "Here you can see all log messages. You can find more detailed log messages in the log file <i>log.tdcs.log</i>."))

#----------------------------------------------------------------------------#