###############################################
##      Filename:     schedule_table.py      ##
##      Date:         16/06/2020             ##
##      Author:       Ayman HATOUM           ##
###############################################
"""This file contains the class definition of scheduleTable(). A subclass
of QTableWidget() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import Qt 
from PyQt5.QtWidgets import QTableWidget
from PyQt5.QtWidgets import QAbstractItemView
from PyQt5.QtWidgets import QHeaderView
from PyQt5.QtWidgets import QTableWidgetItem
from src.constants import whatsThisMsg

#----------------------------------------------------------------------------#

class scheduleTable(QTableWidget) :
    "Schedule class table"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing schedule table...")
        super().__init__(parent)

        self.horizontalHeaders = ["Slot", "Target", "Task", "Slot Start", "Overlap Bound", "Buffer Start", "Slot End",
            "Task Start", "WCET", "Tx Time"]

        self.setColumnCount(len(self.horizontalHeaders))
        self.setHorizontalHeaderLabels(self.horizontalHeaders)
        header = self.horizontalHeader()
        header.setSectionResizeMode(0, QHeaderView.ResizeToContents)
        header.setSectionResizeMode(1, QHeaderView.Interactive)
        header.resizeSection(1, 180)
        header.setSectionResizeMode(2, QHeaderView.Stretch)
        header.setSectionResizeMode(3, QHeaderView.Stretch)
        header.setSectionResizeMode(4, QHeaderView.Stretch)
        header.setSectionResizeMode(5, QHeaderView.Stretch)
        header.setSectionResizeMode(6, QHeaderView.Stretch)
        header.setSectionResizeMode(7, QHeaderView.Stretch)
        header.setSectionResizeMode(8, QHeaderView.Stretch)
        header.setSectionResizeMode(9, QHeaderView.Stretch)
        self.verticalHeader().setVisible(False)
        self.verticalHeader().setSectionResizeMode(QHeaderView.ResizeToContents)
        self.setEditTriggers(QAbstractItemView.NoEditTriggers)

        self.setWhatsThis(whatsThisMsg.format("Schedule Table", "Here you can find all information about <strong>Scheduled Slots</strong> after successfully generating a schedule."))

    def restart(self) :
        logging.getLogger(__name__).debug("Restarting schedule table...")
        self.horizontalHeader().resizeSection(1, 180)
        for row in range(self.rowCount()) :
            self.removeRow(0)

    def addItem(self, slot, target, task, slotStart, overlapBound, buffStart, slotEnd, taskStart, WCET, txTime) :
        logging.getLogger(__name__).debug("Adding item...")
        row = self.rowCount()
        self.insertRow(row)

        slotItem = QTableWidgetItem()
        slotItem.setTextAlignment(Qt.AlignHCenter | Qt.AlignVCenter)
        slotItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        slotItem.setData(Qt.DisplayRole, slot)
        self.setItem(row, 0, slotItem)

        targetItem = QTableWidgetItem()
        targetItem.setTextAlignment(Qt.AlignLeft | Qt.AlignVCenter)
        targetItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        font = targetItem.font()
        font.setBold(True)
        targetItem.setFont(font)
        targetItem.setText(target)
        self.setItem(row, 1, targetItem)

        taskItem = QTableWidgetItem()
        taskItem.setTextAlignment(Qt.AlignLeft | Qt.AlignVCenter)
        taskItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        taskItem.setText(task)
        self.setItem(row, 2, taskItem)

        slotStartItem = QTableWidgetItem()
        slotStartItem.setTextAlignment(Qt.AlignRight | Qt.AlignVCenter)
        slotStartItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        slotStartItem.setData(Qt.DisplayRole, slotStart)
        self.setItem(row, 3, slotStartItem)

        overlapBoundItem = QTableWidgetItem()
        overlapBoundItem.setTextAlignment(Qt.AlignRight | Qt.AlignVCenter)
        overlapBoundItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        overlapBoundItem.setData(Qt.DisplayRole, overlapBound)
        self.setItem(row, 4, overlapBoundItem)

        buffStartItem = QTableWidgetItem()
        buffStartItem.setTextAlignment(Qt.AlignRight | Qt.AlignVCenter)
        buffStartItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        buffStartItem.setData(Qt.DisplayRole, buffStart)
        self.setItem(row, 5, buffStartItem)

        slotEndItem = QTableWidgetItem()
        slotEndItem.setTextAlignment(Qt.AlignRight | Qt.AlignVCenter)
        slotEndItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        slotEndItem.setData(Qt.DisplayRole, slotEnd)
        self.setItem(row, 6, slotEndItem)

        taskStartItem = QTableWidgetItem()
        taskStartItem.setTextAlignment(Qt.AlignRight | Qt.AlignVCenter)
        taskStartItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        taskStartItem.setData(Qt.DisplayRole, taskStart)
        self.setItem(row, 7, taskStartItem)

        wcetItem = QTableWidgetItem()
        wcetItem.setTextAlignment(Qt.AlignRight | Qt.AlignVCenter)
        wcetItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        wcetItem.setData(Qt.DisplayRole, WCET)
        self.setItem(row, 8, wcetItem)

        txTimeItem = QTableWidgetItem()
        txTimeItem.setTextAlignment(Qt.AlignRight | Qt.AlignVCenter)
        txTimeItem.setFlags(Qt.ItemIsEnabled | Qt.ItemIsSelectable)
        txTimeItem.setData(Qt.DisplayRole, txTime)
        self.setItem(row, 9, txTimeItem)

#----------------------------------------------------------------------------#