###############################################
##      Filename:     time_axis_item.py      ##
##      Date:         18/06/2020             ##
##      Author:       Ayman HATOUM           ##
###############################################
"""This file contains the class definition of timeAxisItem(). A subclass
of QGraphicsItem() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import QRectF
from PyQt5.QtCore import QMarginsF
from PyQt5.QtCore import QPointF
from PyQt5.QtWidgets import QGraphicsItem
from PyQt5.QtGui import QPolygonF
from src.constants import marginLength
from src.constants import tickLength
from src.constants import smallTickHeight
from src.constants import bigTickHeight
from src.constants import arrowBaseHalf

#----------------------------------------------------------------------------#

class timeAxisItem(QGraphicsItem) :
    "Time axis item class"
    def __init__(self, rect, axisRes) :
        logging.getLogger(__name__).debug("Constructing time axis item...")
        super().__init__()
        
        self.rect = rect
        self.axisRes = axisRes

    def updateAxisRes(self, axisRes) :
        logging.getLogger(__name__).debug("Updating axis resolution...")
        self.axisRes = axisRes

    def paint(self, painter, options, widget) :
        axisLength = self.rect.width() - 2*marginLength
        axisYpos = self.rect.height()/2

        painter.drawLine(marginLength, axisYpos, axisLength + marginLength, axisYpos)
        
        arrowPoints = [QPointF(axisLength + marginLength - arrowBaseHalf, axisYpos - arrowBaseHalf), QPointF(axisLength + marginLength, axisYpos),
            QPointF(axisLength + marginLength - arrowBaseHalf, axisYpos + arrowBaseHalf)]
        painter.drawPolyline(QPolygonF(arrowPoints))

        for tick in range(int(axisLength/tickLength)) :
            if tick % 10 == 0 :
                tickHeight = bigTickHeight
                painter.drawText(marginLength + tick*tickLength, axisYpos + tickHeight + 12, str(tick*int(self.axisRes.split(" ")[0])))
            else :
                tickHeight = smallTickHeight
            painter.drawLine(marginLength + tick*tickLength, axisYpos - tickHeight, marginLength + tick*tickLength, axisYpos + tickHeight)
        
        font = painter.font()
        font.setPointSize(12)
        painter.setFont(font)
        painter.drawText(axisLength + marginLength, axisYpos + bigTickHeight + 12, "t ({})".format(self.axisRes.split(" ")[1]))

    def boundingRect(self) :
        return QRectF(self.rect) + QMarginsF(1, 1, 1, 1)

#----------------------------------------------------------------------------#