###################################################
##      Filename:     task_timeline_item.py      ##
##      Date:         24/06/2020                 ##
##      Author:       Ayman HATOUM               ##
###################################################
"""This file contains the class definition of taskTimelineItem(). A subclass
of QGraphicsItem() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import QRectF
from PyQt5.QtCore import QMarginsF
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QGraphicsItem
from PyQt5.QtGui import QColor
from src import tools
from src.constants import taskTimelineHeight
from src.constants import tickLength

#----------------------------------------------------------------------------#

class taskTimelineItem(QGraphicsItem) :
    "Task timeline item class"
    def __init__(self, parent, name, wcet, tx, color, taskType) :
        logging.getLogger(__name__).debug("Constructing task timeline item...")
        super().__init__(parent)

        self.target = parent
        self.name = name
        self.WCET = wcet*tickLength
        self.Tx = tx*tickLength
        self.color = color
        self.penStyle = Qt.DashLine if taskType == tools.FreeTask else Qt.SolidLine
        
        self.rect = QRectF(0, 0, self.WCET + self.Tx, taskTimelineHeight)

    def paint(self, painter, options, widget) :
        brush = painter.brush()
        brush.setColor(QColor(self.color))
        brush.setStyle(Qt.SolidPattern)
        pen = painter.pen()
        pen.setWidth(2)
        pen.setStyle(self.penStyle)
        painter.setBrush(brush)
        painter.setPen(pen)

        painter.drawRoundedRect(self.rect, 5, 5)
        
        font = painter.font()
        font.setBold(True)
        painter.setFont(font)
        painter.drawText(QRectF(0, 0, self.WCET, taskTimelineHeight), Qt.AlignCenter | Qt.TextWordWrap, self.name+"\nWCET")

        if self.Tx != 0 :
            pen.setWidth(1)
            pen.setStyle(Qt.DashLine)
            painter.setPen(pen)
            painter.drawLine(self.WCET, 0, self.WCET, taskTimelineHeight)

            font.setFamily("Courier")
            font.setBold(False)
            painter.setFont(font)
            painter.drawText(QRectF(self.WCET, 0, self.Tx, taskTimelineHeight), Qt.AlignCenter | Qt.TextWordWrap, "Tx")
        
    def boundingRect(self) :
        return self.rect + QMarginsF(1, 1, 1, 1)

#----------------------------------------------------------------------------#