####################################################
##      Filename:     slot_separator_item.py      ##
##      Date:         03/07/2020                  ##
##      Author:       Ayman HATOUM                ##
####################################################
"""This file contains the class definition of slotSeparatorItem(). A subclass
of QGraphicsItem() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import QRectF
from PyQt5.QtCore import QMarginsF
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QGraphicsItem

#----------------------------------------------------------------------------#

class slotSeparatorItem(QGraphicsItem) :
    "Slot separator item class"
    def __init__(self, height) :
        logging.getLogger(__name__).debug("Constructing slot separator item...")
        super().__init__()

        self.height = height

        self.rect = QRectF(0, 0, 1, self.height)

    def paint(self, painter, options, widget) :
        painter.drawLine(0, 0, 0, self.height)

    def boundingRect(self) :
        return QRectF(self.rect) + QMarginsF(1, 1, 1, 1)

#----------------------------------------------------------------------------#