###############################################
##      Filename:     legend_item.py         ##
##      Date:         25/06/2020             ##
##      Author:       Ayman HATOUM           ##
###############################################
"""This file contains the class definition of legendItem(). A subclass
of QGraphicsItem() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import QRectF
from PyQt5.QtCore import QMarginsF
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QGraphicsItem
from PyQt5.QtGui import QColor

#----------------------------------------------------------------------------#

class legendItem(QGraphicsItem) :
    "Legend item class"
    def __init__(self, period, baudRate) :
        logging.getLogger(__name__).debug("Constructing schedule legend item...")
        super().__init__()

        self.period = period
        self.baudRate = baudRate
        self.rect = QRectF(0, 0, 120, 70)

    def paint(self, painter, options, widget) :
        brush = painter.brush()
        brush.setColor(QColor("ghostwhite"))
        brush.setStyle(Qt.SolidPattern)
        font = painter.font()
        font.setPointSize(10)
        font.setBold(True)
        painter.setBrush(brush)
        painter.setFont(font)

        painter.drawRect(self.rect)
        painter.drawText(self.rect, Qt.AlignJustify | Qt.AlignCenter, "T = {}\nBR = {}".format(self.period, self.baudRate))

    def boundingRect(self) :
        return self.rect + QMarginsF(1, 1, 20, 1)

#----------------------------------------------------------------------------#