###############################################
##      Filename:     central_window.py      ##
##      Date:         18/04/2020             ##
##      Author:       Ayman HATOUM           ##
###############################################
"""This file contains the class definition of centralWindow(). A subclass
of QTabWidget() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtWidgets import QTabWidget
from src.windows.central.builder.builder_window import builderWindow
from src.windows.central.scheduler.scheduler_window import schedulerWindow

#----------------------------------------------------------------------------#

class centralWindow(QTabWidget) :
    "Central class window"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing central window")
        super().__init__(parent)
        
        self.createLayout(parent)
        
    def createLayout(self, parent) :
        "Creates layout"
        self.builder = builderWindow(parent)
        self.scheduler = schedulerWindow(parent)
        
        self.setTabPosition(QTabWidget.South)
        self.addTab(self.builder, "Builder")
        self.addTab(self.scheduler, "Scheduler")

#----------------------------------------------------------------------------#