###############################################
##      Filename:     task_port_item.py      ##
##      Date:         27/04/2020             ##
##      Author:       Ayman HATOUM           ##
###############################################
"""This file contains the class definition of taskPortItem(). 
A subclass of QGraphicsEllipseItem() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QGraphicsEllipseItem
from PyQt5.QtWidgets import QGraphicsItem
from PyQt5.QtGui import QBrush
from PyQt5.QtGui import QColor
from src.constants import portRadius
from src.constants import defaultInt
from src.constants import defaultFloat
from src.constants import defaultBool
from src.constants import colorInt
from src.constants import colorFloat
from src.constants import colorBool

#----------------------------------------------------------------------------#

class taskPortItem(QGraphicsEllipseItem) :
    "Task port item class"
    Input, Output = range(2)
    def __init__(self, parent, direction, value) :
        logging.getLogger(__name__).debug("Constructing port...")
        super().__init__(parent)
        
        self.task = parent
        self.direction = direction
        self.label = value.label
        self.typ = value.type
        self.setupDrawing()
        if self.direction == self.Input :
            self.setupInput(value)
        else :
            self.setupOutput()
    
        self.setCursor(Qt.CrossCursor)
        self.setAcceptedMouseButtons(Qt.LeftButton)
        self.setFlag(QGraphicsItem.ItemSendsScenePositionChanges)
    
    def updateDefaultValue(self, value) :
        logging.getLogger(__name__).debug("Updating default port's value...")
        self.defaultValue = value
        self.setToolTip("<b>Label:</b> "+self.label+"<br><b>Type:</b> "+self.typ+"<br><b>Default:</b> "+str(self.defaultValue))
    
    def setupDrawing(self) :
        self.setRect(0, 0, 2*portRadius, 2*portRadius)
        self.pen = self.pen()
        self.pen.setWidthF(1.5)
        self.setPen(self.pen)
        if self.typ == "int" :
            self.brush = QBrush(QColor(colorInt))
        elif self.typ == "float" :
            self.brush = QBrush(QColor(colorFloat))
        else :
            self.brush = QBrush(QColor(colorBool))
        self.setBrush(self.brush)

    def setupInput(self, value) :
        self.connection = None
        self.defaultValue = value.default
        if self.typ == "int" or self.typ == "float" :
            self.minValue = value.min
            self.maxValue = value.max
        self.setToolTip("<b>Label:</b> "+self.label+"<br><b>Type:</b> "+self.typ+"<br><b>Default:</b> "+str(self.defaultValue))
    
    def setupOutput(self) :
        self.connections = []
        self.setToolTip("<b>Label:</b> "+self.label+"<br><b>Type:</b> "+self.typ)

    # def setDefaultValue(self) :
    #     if self.typ == "int" :
    #         self.defaultValue = defaultInt
    #     elif self.typ == "float" :
    #         self.defaultValue = defaultFloat
    #     else :
    #         self.defaultValue = defaultBool
            
    def isEligible(self, port) :
        logging.getLogger(__name__).debug("Checking port's eligibility...")
        return True if port.direction != self.direction else False
        
    def matchType(self, typ) :
        logging.getLogger(__name__).debug("Checking if port's type matches...")
        return True if self.typ == typ else False
       
    def mousePressEvent(self, event) :
        self.scene().clearSelection()
        event.accept()
        
    def itemChange(self, change, value) :
        if change == QGraphicsItem.ItemScenePositionHasChanged :
            if self.direction == self.Input :
                if self.connection :
                    # self.connection.update()
                    self.connection.prepareGeometryChange()
            else :
                if self.connections :
                    for connection in self.connections :
                        # connection.update()
                        connection.prepareGeometryChange()
        return QGraphicsEllipseItem.itemChange(self, change, value)
        
#----------------------------------------------------------------------------#