#############################################
##      Filename:     main_actions.py      ##
##      Date:         18/04/2020           ##
##      Author:       Ayman HATOUM         ##
#############################################
"""This file contains the class definition of mainActions()."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtWidgets import QAction
from PyQt5.QtWidgets import QActionGroup
from PyQt5.QtGui import QIcon
from src.constants import aboutIcon
from src.constants import displayIcon
from src.constants import picturesPath
from src.constants import newIcon
from src.constants import openIcon
from src.constants import saveIcon
from src.constants import saveAsIcon
from src.constants import logDebugIcon
from src.constants import exportScheduleIcon
from src.constants import exitIcon
from src.constants import removeIcon
from src.constants import settingsIcon
from src.constants import zoomInIcon
from src.constants import zoomOutIcon
from src.constants import newTargetIcon
from src.constants import selectToolIcon
from src.constants import panToolIcon
from src.constants import generateIcon
from src.constants import helpContentsIcon
from src.constants import whatsThisMsg

#----------------------------------------------------------------------------#

class mainActions() :
    "Main actions class"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing main actions...")
        self.fileMenuActions(parent)
        self.editMenuActions(parent)
        self.viewMenuActions(parent)
        self.insertMenuActions(parent)
        self.toolsMenuActions(parent)
        self.helpMenuActions(parent)
        
    def fileMenuActions(self, parent) :
        logging.getLogger(__name__).debug("Creating file menu actions...")
        #Action: New
        self.newAction = QAction(QIcon(picturesPath+newIcon), "New Project", parent)
        self.newAction.setShortcut("Ctrl+N")
        self.newAction.triggered.connect(parent.newProject)
        self.newAction.setEnabled(False)
        self.newAction.setWhatsThis(whatsThisMsg.format("New Project", "Use this command to create a new project from scratch. You can access it from <strong>File Menu</strong> | <strong>Tool Bar</strong> | <strong>Ctrl+N</strong>."))
        #Action: Open
        self.openAction = QAction(QIcon(picturesPath+openIcon), "Open Project", parent)
        self.openAction.setShortcut("Ctrl+O")
        self.openAction.triggered.connect(parent.showOpenDialog)
        self.openAction.setWhatsThis(whatsThisMsg.format("Open Project", "Use this command to open an existing project. You can access it from <strong>File Menu</strong> | <strong>Tool Bar</strong> | <strong>Ctrl+O</strong>."))
        #Action: Save
        self.saveAction = QAction(QIcon(picturesPath+saveIcon), "Save", parent)
        self.saveAction.setShortcut("Ctrl+S")
        self.saveAction.setEnabled(False)
        self.saveAction.triggered.connect(parent.save)
        self.saveAction.setWhatsThis(whatsThisMsg.format("Save", "Use this command to save your current project. You can access it from <strong>File Menu</strong> | <strong>Tool Bar</strong> | <strong>Ctrl+S</strong>."))
        #Action: Save as
        self.saveAsAction = QAction(QIcon(picturesPath+saveAsIcon), "Save as", parent)
        self.saveAsAction.setShortcut("Ctrl+Shift+S")
        self.saveAsAction.triggered.connect(parent.showSaveAsDialog)
        self.saveAsAction.setWhatsThis(whatsThisMsg.format("Save As", "Use this command to save your current project as a new project. You can access it from <strong>File Menu</strong> | <strong>Tool Bar</strong> | <strong>Ctrl+Shift+S</strong>."))
        #Action: Log/Debugging
        self.logDebugAction = QAction(QIcon(picturesPath+logDebugIcon), "Debugging", parent)
        self.logDebugAction.setCheckable(True)
        self.logDebugAction.triggered.connect(parent.checkLogDebug)
        self.logDebugAction.setWhatsThis(whatsThisMsg.format("Debugging", "Activate this option to enable debug messages in the log file. You can access it from <strong>File Menu -> Log</strong> | <strong>Tool Bar</strong>."))
        #Action: Export/Schedule Script
        self.exportScheduleAction = QAction(QIcon(picturesPath+exportScheduleIcon), "Schedule Script", parent)
        self.exportScheduleAction.setShortcut("Ctrl+E")
        self.exportScheduleAction.setEnabled(False)
        self.exportScheduleAction.triggered.connect(parent.exportSchedule)
        self.exportScheduleAction.setWhatsThis(whatsThisMsg.format("Schedule Script", "Use this command to export schedule script (.ss.json). You can access it from <strong>File Menu -> Export</strong> | <strong>Tool Bar</strong> | <strong>Ctrl+E</strong>."))
        #Action: Export/Schedule Description
        self.exportScheduleDescriptionAction = QAction(QIcon(picturesPath+exportScheduleIcon), "Schedule Description", parent)
        self.exportScheduleDescriptionAction.setShortcut("Ctrl+Shift+E")
        self.exportScheduleDescriptionAction.setEnabled(False)
        self.exportScheduleDescriptionAction.triggered.connect(parent.exportScheduleDescription)
        self.exportScheduleDescriptionAction.setWhatsThis(whatsThisMsg.format("Schedule Description", "Use this command to export schedule description (.sd.json). You can access it from <strong>File Menu -> Export</strong> | <strong>Ctrl+Shift+E</strong>."))
        #Action: Quit
        self.exitAction = QAction(QIcon(picturesPath+exitIcon), "Quit", parent)
        self.exitAction.setShortcut("Ctrl+Q")
        self.exitAction.triggered.connect(parent.close)
        self.exitAction.setWhatsThis(whatsThisMsg.format("Quit", "Use this command to quit the application. You can access it from <strong>File Menu</strong> | <strong>Close Corner Button</strong> | <strong>Ctrl+Q</strong>."))

    def editMenuActions(self, parent) :
        logging.getLogger(__name__).debug("Creating edit menu actions...")
        #Action: Remove selected
        self.removeSelectedAction = QAction(QIcon(picturesPath+removeIcon), "Remove Selected", parent)
        self.removeSelectedAction.setShortcut("Del")
        self.removeSelectedAction.triggered.connect(parent.removeSelectedItems)
        self.removeSelectedAction.setEnabled(False)
        self.removeSelectedAction.setWhatsThis(whatsThisMsg.format("Remove Selected", "Use this command to remove selected items from builder's scene. You can access it from <strong>Edit Menu</strong> | <strong>Tool Bar</strong> | <strong>Builder Context Menu</strong> | <strong>Del</strong>."))
        #Action: Display settings
        self.displaySettingsAction = QAction(QIcon(picturesPath+displayIcon), "Display Settings", parent)
        self.displaySettingsAction.setShortcut("Ctrl+D")
        self.displaySettingsAction.triggered.connect(parent.showDisplaySettingsDialog)
        self.displaySettingsAction.setWhatsThis(whatsThisMsg.format("Display Settings", "Use this command to access display settings and modify parameters. You can access it from <strong>Edit Menu</strong> | <strong>Ctrl+D</strong>."))
        #Action: Preference settings
        self.prefSettingsAction = QAction(QIcon(picturesPath+settingsIcon), "Preference Settings", parent)
        self.prefSettingsAction.setShortcut("Ctrl+T")
        self.prefSettingsAction.triggered.connect(parent.showPrefSettingsDialog)
        self.prefSettingsAction.setWhatsThis(whatsThisMsg.format("Preference Settings", "Use this command to access preference settings and modify parameters. You can access it from <strong>Edit Menu</strong> | <strong>Ctrl+T</strong>."))

    def viewMenuActions(self, parent) :
        logging.getLogger(__name__).debug("Creating view menu actions...")
        #Action: Zoom in
        self.zoomInAction = QAction(QIcon(picturesPath+zoomInIcon), "Zoom In (Ctrl+Mouse Wheel Up)", parent)
        self.zoomInAction.triggered.connect(parent.zoomIn)
        self.zoomInAction.setWhatsThis(whatsThisMsg.format("Zoom In", "Use this command to zoom in wether on builder's or schedule's scene. You can access it from <strong>View Menu</strong> | <strong>Tool Bar</strong> | <strong>Ctrl+Mouse Wheel Up</strong>."))
        #Action: Zoom Out
        self.zoomOutAction = QAction(QIcon(picturesPath+zoomOutIcon), "Zoom Out (Ctrl+Mouse Wheel Down)", parent)
        self.zoomOutAction.triggered.connect(parent.zoomOut)
        self.zoomOutAction.setWhatsThis(whatsThisMsg.format("Zoom Out", "Use this command to zoom out wether on builder's or schedule's scene. You can access it from <strong>View Menu</strong> | <strong>Tool Bar</strong> | <strong>Ctrl+Mouse Wheel Down</strong>."))
        #Action: Reset Zoom
        self.resetZoomAction = QAction("Reset Zoom", parent)
        self.resetZoomAction.triggered.connect(parent.resetZoom)
        self.resetZoomAction.setWhatsThis(whatsThisMsg.format("Reset Zoom", "Use this command to reset zoom wether on builder's or schedule's scene. You can access it from <strong>View Menu</strong> | <strong>Tool Bar</strong>."))
        
    def insertMenuActions(self, parent) :
        logging.getLogger(__name__).debug("Creating insert menu actions...")
        #Action: Insert target
        self.newTargetAction = QAction(QIcon(picturesPath+newTargetIcon), "New Target", parent)
        self.newTargetAction.setShortcut("Ctrl+I")
        self.newTargetAction.triggered.connect(parent.showNewTargetDialog)
        self.newTargetAction.setWhatsThis(whatsThisMsg.format("New Target", "Use this command to insert new target into targets window. You can access it from <strong>Insert Menu</strong> | <strong>Tool Bar</strong> | <strong>Targets Window Context Menu</strong> | <strong>Ctrl+I</strong>."))
        
    def toolsMenuActions(self, parent) :
        logging.getLogger(__name__).debug("Creating tools menu actions...")
        #Action group: Mode tool
        self.modeToolActionGroup = QActionGroup(parent)
        self.modeToolActionGroup.triggered.connect(parent.toggleDragMode)
        #Action: Select tool
        self.selectToolAction = QAction(QIcon(picturesPath+selectToolIcon), "Select Tool", parent)
        self.selectToolAction.setCheckable(True)
        self.selectToolAction.setChecked(True)
        self.selectToolAction.setActionGroup(self.modeToolActionGroup)
        self.selectToolAction.setWhatsThis(whatsThisMsg.format("Select Tool", "Activate this option to enable selecting tool in builder's scene. You can access it from <strong>Tools Menu</strong> | <strong>Tool Bar</strong>."))
        #Action: Pan tool
        self.panToolAction = QAction(QIcon(picturesPath+panToolIcon), "Pan Tool", parent)
        self.panToolAction.setCheckable(True)
        self.panToolAction.setActionGroup(self.modeToolActionGroup)
        self.panToolAction.setWhatsThis(whatsThisMsg.format("Pan Tool", "Activate this option to enable panning tool in builder's scene. You can access it from <strong>Tools Menu</strong> | <strong>Tool Bar</strong>."))
        #Action: Generate schedule
        self.generateAction = QAction(QIcon(picturesPath+generateIcon), "Generate Schedule", parent)
        self.generateAction.setShortcut("Ctrl+G")
        self.generateAction.setEnabled(False)
        self.generateAction.triggered.connect(parent.generateSchedule)
        self.generateAction.setWhatsThis(whatsThisMsg.format("Generate Schedule", "Use this command to generate schedule. You can access it from <strong>Tools Menu</strong> | <strong>Tool Bar</strong> | <strong>Ctrl+G</strong>."))
        
    def helpMenuActions(self, parent) :
        logging.getLogger(__name__).debug("Creating help menu actions...")
        #Action: Help contents
        self.helpContentsAction = QAction(QIcon(picturesPath+helpContentsIcon), "Help Contents...", parent)
        self.helpContentsAction.setShortcut("F1")
        self.helpContentsAction.triggered.connect(parent.helpContents)
        self.helpContentsAction.setWhatsThis(whatsThisMsg.format("Help Contents", "Use this command to help contents browser. You can access it from <strong>Help Menu</strong> | <strong>F1</strong>."))
        #Action: On item
        self.onItemAction = QAction("On Item...", parent)
        self.onItemAction.setShortcut("Shift+F1")
        self.onItemAction.triggered.connect(parent.onItemHelp)
        self.onItemAction.setWhatsThis(whatsThisMsg.format("Help On Item", "Use this command to activate <i>WhatsThis</i> mode and get help on each item you click over. You can access it from <strong>Help Menu</strong> | <strong>Shift+F1</strong>."))
        #Action: About
        self.aboutAction = QAction(QIcon(picturesPath+aboutIcon), "About", parent)
        self.aboutAction.triggered.connect(parent.about)
        self.aboutAction.setWhatsThis(whatsThisMsg.format("About", "Use this command to show <i>about</i> info of application. You can access it from <strong>Help Menu</strong>."))

#----------------------------------------------------------------------------#