##########################################
##      Filename:     main.py           ##
##      Date:         18/04/2020        ##
##      Author:       Ayman HATOUM      ##
##########################################
"""This file contains the main function and execution loop of the app."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import json
import logging
import sys
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QApplication
from src import tools
from src.constants import applicationName
from src.main_window import mainWindow

#----------------------------------------------------------------------------#

def main() :
    "Main Function"
    if len(sys.argv) == 1 :
        app = QApplication(sys.argv)
        # app.setAttribute(Qt.AA_DontShowIconsInMenus)
        app.setOrganizationName("KAI")
        app.setApplicationName("TDCS")
        app.setApplicationVersion("1.0")
        app.setApplicationDisplayName(applicationName)
        window = mainWindow()
        window.show()
        logging.getLogger(__name__).debug("Entering event loop...")
        sys.exit(app.exec())
    else :
        try :
            flag = sys.argv[1]
            if flag == "--complete-check" :
                try :
                    scriptPath = sys.argv[2]
                    if tools.scheduleScriptCheck(scriptPath) :
                        return 0
                    else :
                        return -1
                except IndexError :
                    print("\nusage: tdcs [--complete-check <path>]\n\n")
                except FileNotFoundError :
                    print("\n{} cannot be found. Make sure you typed the name correctly, and then try again.\n\n".format(scriptPath))
            else :
                print("\nusage: tdcs [--complete-check <path>]\n\n")
        except IndexError :
            print("\nusage: tdcs [--complete-check <path>]\n\n")
            


#----------------------------------------------------------------------------#