############################################
##      Filename:     save_dialog.py      ##
##      Date:         23/05/2020          ##
##      Author:       Ayman HATOUM        ##
############################################
"""This file contains the class definition of saveDialog(). 
A subclass of QMessageBox() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import pathlib, logging
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QMessageBox
from PyQt5.QtWidgets import qApp

#----------------------------------------------------------------------------#

class saveDialog(QMessageBox) :
    "Save dialog class"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing save message box...")
        super().__init__(parent)
        
        self.mainWindow = parent
        self.fileName = pathlib.Path(self.mainWindow.currentProjectName).name
        
        self.setWindowTitle("Save") 

        self.setIcon(QMessageBox.Warning)
        self.setText("<font size='+2'>Do you want to save the changes you made to "+self.fileName+".srtt?</font>")
        self.setTextFormat(Qt.RichText)
        self.setInformativeText("Your changes will be lost if you don't save them.")

        self.saveButt = self.addButton(QMessageBox.Save)
        self.discardButt = self.addButton(QMessageBox.Discard)
        self.cancelButt = self.addButton(QMessageBox.Cancel)

        self.setDefaultButton(self.saveButt)
        self.setEscapeButton(self.cancelButt)

    def showEvent(self, event) :
        qApp.beep()
        QMessageBox.showEvent(self, event)
                
#----------------------------------------------------------------------------#