################################################
##      Filename:     progress_dialog.py      ##
##      Date:         07/08/2020              ##
##      Author:       Ayman HATOUM            ##
################################################
"""This file contains the class definition of progressDialog(). 
A subclass of QDialog() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QDialog
from PyQt5.QtWidgets import QLabel
from PyQt5.QtWidgets import QGridLayout
from PyQt5.QtWidgets import QLayout
from PyQt5.QtWidgets import QProgressBar

#----------------------------------------------------------------------------#

class progressDialog(QDialog) :
    "Progress dialog class"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing progress dialog...")
        super().__init__(parent)
        
        self.setWindowFlag(Qt.WindowCloseButtonHint, False)
        self.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
        
        self.msg = QLabel("<font size='+2'>Generating schedule...</font>")
        self.progressBar = QProgressBar()
        self.progressBar.setRange(0, 0)
        self.progressBar.setTextVisible(False)
        self.progressBar.setFixedWidth(400)
        
        self.layout = QGridLayout()
        self.layout.addWidget(self.msg, 0, 0, Qt.AlignCenter)
        self.layout.addWidget(self.progressBar, 1, 0, Qt.AlignCenter)
        self.layout.setSpacing(10)
        self.layout.setSizeConstraint(QLayout.SetFixedSize)
        self.setLayout(self.layout)

    def keyPressEvent(self, event) :
        event.ignore()
                
#----------------------------------------------------------------------------#