##################################################
##      Filename:     new_target_dialog.py      ##
##      Date:         20/04/2020                ##
##      Author:       Ayman HATOUM              ##
##################################################
"""This file contains the class definition of newTargetDialog(). 
A subclass of QDialog() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtWidgets import QDialog
from PyQt5.QtWidgets import QLabel
from PyQt5.QtWidgets import QLineEdit
from PyQt5.QtWidgets import QSpinBox
from PyQt5.QtWidgets import QComboBox
from PyQt5.QtWidgets import QGridLayout
from PyQt5.QtWidgets import QPushButton
from PyQt5.QtWidgets import qApp
from PyQt5.QtWidgets import QLayout
from PyQt5.QtWidgets import QGroupBox
from PyQt5.QtWidgets import QHBoxLayout
from PyQt5.QtWidgets import QVBoxLayout
from src.constants import whatsThisMsg

#----------------------------------------------------------------------------#

class newTargetDialog(QDialog) :
    "New target dialog class"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing new target dialog...")
        super().__init__(parent)
        
        self.mainWindow = parent
        self.data = {}
        
        self.setWindowTitle("New Target")
        
        self.label = QLabel("Target label:", self)
        self.labelInput = QLineEdit(self)
        self.labelInput.setPlaceholderText("Type a label...")
        self.label.setWhatsThis(whatsThisMsg.format("Target Label", "It has to be a <strong>non-empty unique string</strong>."))
        self.labelInput.setWhatsThis(whatsThisMsg.format("Target Label", "It has to be a <strong>non-empty unique string</strong>."))
        
        self.targetType = QLabel("Target type:")
        self.targetTypeInput = QComboBox(self)
        targetNames = list(parent.targets.targetsData.keys())
        targetNames.sort()
        self.targetTypeInput.addItems(targetNames)
        self.targetType.setWhatsThis(whatsThisMsg.format("Target Type", "Choose one of the fetched targets <i>(from target config files)</i>."))
        self.targetTypeInput.setWhatsThis(whatsThisMsg.format("Target Type", "Choose one of the fetched targets <i>(from target config files)</i>."))

        self.assignCanID = QGroupBox("Assign CAN ID", self)
        self.canID = QLabel("CAN ID:", self)
        self.canIDInput = QSpinBox(self)
        self.canIDInput.setMinimum(self.mainWindow.targets.smallestCanIDAvailable)
        self.canID.setWhatsThis(whatsThisMsg.format("CAN ID", "It has to be an <strong>unique positive integer</strong>."))
        self.canIDInput.setWhatsThis(whatsThisMsg.format("CAN ID", "It has to be an <strong>unique positive integer</strong>."))
        self.boxLayout = QHBoxLayout()
        self.boxLayout.addWidget(self.canID)
        self.boxLayout.addWidget(self.canIDInput)
        self.assignCanID.setLayout(self.boxLayout)
        self.assignCanID.setCheckable(True)
        self.assignCanID.setChecked(False)
        self.assignCanID.setToolTip("If left unchecked, the smallest available ID will be automatically assigned.")
        self.assignCanID.toggled.connect(self.checkAssignCanID)
        self.assignCanID.setWhatsThis(whatsThisMsg.format("Assign CAN ID", "You can check this option and assing CAN ID manually. Or leave it unchecked and CAN ID will be assigned <strong>automatically</strong>."))

        self.targetsCount = QLabel("Number of targets:")
        self.targetsCountInput = QSpinBox(self)
        self.targetsCountInput.setMinimum(1)
        self.targetsCount.setWhatsThis(whatsThisMsg.format("Number Of Targets", "Defines how many instance you want from the target being inserted. Target label will be <i>indexed incrementally</i>."))
        self.targetsCountInput.setWhatsThis(whatsThisMsg.format("Number Of Targets", "Defines how many instance you want from the target being inserted. Target label will be <i>indexed incrementally</i>."))
        
        self.okButt = QPushButton("OK", self)
        self.okButt.setDefault(True)
        self.okButt.clicked.connect(self.accept)
        self.cancelButt = QPushButton("Cancel", self)
        self.cancelButt.clicked.connect(self.reject)
        
        self.labelLayout = QHBoxLayout()
        self.labelLayout.addWidget(self.label)
        self.labelLayout.addWidget(self.labelInput)
        self.labelLayout.setSpacing(10)

        self.targetTypeLayout = QHBoxLayout()
        self.targetTypeLayout.addWidget(self.targetType)
        self.targetTypeLayout.addWidget(self.targetTypeInput, 1)
        self.targetTypeLayout.setSpacing(10)

        self.targetsCountLayout = QHBoxLayout()
        self.targetsCountLayout.addWidget(self.targetsCount)
        self.targetsCountLayout.addWidget(self.targetsCountInput)
        self.targetsCountLayout.setSpacing(10)

        self.buttonsLayout = QHBoxLayout()
        self.buttonsLayout.addWidget(self.okButt)
        self.buttonsLayout.addWidget(self.cancelButt)
        self.buttonsLayout.setSpacing(10)

        self.layout = QVBoxLayout()
        self.layout.addLayout(self.labelLayout)
        self.layout.addLayout(self.targetTypeLayout)
        self.layout.addWidget(self.assignCanID)
        self.layout.addLayout(self.targetsCountLayout)
        self.layout.addLayout(self.buttonsLayout)
        
        self.layout.setSpacing(10)
        self.layout.setSizeConstraint(QLayout.SetFixedSize)
        
        self.setLayout(self.layout)

    def checkAssignCanID(self, check) :
        logging.getLogger(__name__).debug("Checking smallest CAN ID available...")
        if check == False :
            self.canIDInput.setValue(self.mainWindow.targets.smallestCanIDAvailable)

    def accept(self) :
        if self.labelInput.text() == "" :
            self.labelInput.setFocus()
            self.mainWindow.statusBar_.showMessage("The label should not be empty!", 5000)
            qApp.beep()
            logging.getLogger(__name__).warning("The label should not be empty!")
            return
        elif self.labelInput.text() in self.mainWindow.targets.tree.labelList :
            self.labelInput.setFocus()
            self.mainWindow.statusBar_.showMessage("Label already created! Type new one...", 5000)
            qApp.beep()
            logging.getLogger(__name__).warning("Label: '{}' already created! Type new one...".format(self.labelInput.text()))
            return            
        elif self.assignCanID.isChecked() and self.canIDInput.value() in self.mainWindow.targets.tree.canIDList :
            self.canIDInput.setFocus()
            self.mainWindow.statusBar_.showMessage("CAN ID already created! Choose new one...", 5000)
            qApp.beep()
            logging.getLogger(__name__).warning("CAN ID: [{}] already created! Choose new one...".format(self.canIDInput.value()))
            return   
        elif self.targetsCountInput.value() > 1 :
            count = self.targetsCountInput.value()
            canID = self.canIDInput.value()
            for i in range(1, count) :
                if canID+i in self.mainWindow.targets.tree.canIDList :
                    self.targetsCountInput.setFocus()
                    self.mainWindow.statusBar_.showMessage("CAN ID already created! Change the number of targets...", 5000)
                    qApp.beep()
                    logging.getLogger(__name__).warning("CAN ID: [{}] already created! Change the number of targets...".format(canID+i))
                    return
            label = self.labelInput.text()+"_"
            for i in range(1, count+1) :
                if label+str(i) in self.mainWindow.targets.tree.labelList :
                    self.targetsCountInput.setFocus()
                    self.mainWindow.statusBar_.showMessage("Label index already created! Change the number of targets...", 5000)
                    qApp.beep()
                    logging.getLogger(__name__).warning("Label: '{}' already created! Change the number of targets...".format(label+str(i)))
                    return 
                
                
        self.data[self.label.text().strip(":")] = self.labelInput.text()
        self.data[self.canID.text().strip(":")] = self.canIDInput.value() if self.assignCanID.isChecked() else None
        self.data[self.targetType.text().strip(":")] = self.targetTypeInput.currentText()
        self.data[self.targetsCount.text().strip(":")] = self.targetsCountInput.value()
        QDialog.accept(self)
                
#----------------------------------------------------------------------------#