#####################################################
##      Filename:     modify_target_dialog.py      ##
##      Date:         22/04/2020                   ##
##      Author:       Ayman HATOUM                 ##
#####################################################
"""This file contains the class definition of modifyTargetDialog(). 
A subclass of QDialog() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QDialog
from PyQt5.QtWidgets import QLabel
from PyQt5.QtWidgets import QLineEdit
from PyQt5.QtWidgets import QSpinBox
from PyQt5.QtWidgets import QComboBox
from PyQt5.QtWidgets import QHBoxLayout
from PyQt5.QtWidgets import QVBoxLayout
from PyQt5.QtWidgets import QPushButton
from PyQt5.QtWidgets import qApp
from PyQt5.QtWidgets import QLayout
from PyQt5.QtGui import QColor
from PyQt5.QtGui import QPixmap
from PyQt5.QtGui import QIcon
from src.constants import colorNames
from src.constants import whatsThisMsg

#----------------------------------------------------------------------------#

class modifyTargetDialog(QDialog) :
    "Modify target dialog class"
    def __init__(self, parent, label, canID, color) :
        logging.getLogger(__name__).debug("Constructing modify target dialog...")
        super().__init__(parent)
        
        self.mainWindow = parent
        self.data = {}
        
        self.setWindowTitle("Modify Target")
        
        self.label = QLabel("Target label:", self)
        self.labelInput = QLineEdit(label, self)
        self.labelInput.selectAll()
        self.labelInput.setFixedWidth(150)
        self.labelInput.setPlaceholderText("Type a label...")
        self.label.setWhatsThis(whatsThisMsg.format("Target Label", "It has to be a <strong>non-empty unique string</strong>."))
        self.labelInput.setWhatsThis(whatsThisMsg.format("Target Label", "It has to be a <strong>non-empty unique string</strong>."))
        
        self.canID = QLabel("CAN ID:", self)
        self.canIDInput = QSpinBox(self)
        self.canIDInput.setValue(canID)
        self.canIDInput.setFixedWidth(150)
        self.canID.setWhatsThis(whatsThisMsg.format("CAN ID", "It has to be an <strong>unique positive integer</strong>."))
        self.canIDInput.setWhatsThis(whatsThisMsg.format("CAN ID", "It has to be an <strong>unique positive integer</strong>."))
        
        self.color = QLabel("Painting color:", self)
        self.colorInput = QComboBox(self)
        self.colorInput.setFixedWidth(150)
        self.color.setWhatsThis(whatsThisMsg.format("Painting Color", "Used for painting target's task on the builder. It is intrinsically <strong>unique</strong>."))
        self.colorInput.setWhatsThis(whatsThisMsg.format("Painting Color", "Used for painting target's task on the builder. It is intrinsically <strong>unique</strong>."))
        
        freeColors = list(set(colorNames)-set(self.mainWindow.targets.tree.colorList))
        freeColors.sort()
        for col in freeColors :
            pixmap = QPixmap(15,15)
            pixmap.fill(QColor(col))
            self.colorInput.addItem(QIcon(pixmap), col)
        
        self.colorInput.setCurrentText(color)
        
        self.okButt = QPushButton("OK", self)
        self.okButt.setDefault(True)
        self.okButt.clicked.connect(self.accept)
        self.cancelButt = QPushButton("Cancel", self)
        self.cancelButt.clicked.connect(self.reject)
        
        self.labelLayout = QHBoxLayout()
        self.labelLayout.addWidget(self.label)
        self.labelLayout.addWidget(self.labelInput)
        self.labelLayout.setSpacing(10)

        self.canIDLayout = QHBoxLayout()
        self.canIDLayout.addWidget(self.canID)
        self.canIDLayout.addWidget(self.canIDInput)
        self.canIDLayout.setSpacing(10)

        self.colorLayout = QHBoxLayout()
        self.colorLayout.addWidget(self.color)
        self.colorLayout.addWidget(self.colorInput)
        self.colorLayout.setSpacing(10)

        self.buttonsLayout = QHBoxLayout()
        self.buttonsLayout.addWidget(self.okButt)
        self.buttonsLayout.addWidget(self.cancelButt)
        self.buttonsLayout.setSpacing(10)

        self.layout = QVBoxLayout()
        self.layout.addLayout(self.labelLayout)
        self.layout.addLayout(self.canIDLayout)
        self.layout.addLayout(self.colorLayout)
        self.layout.addLayout(self.buttonsLayout)
        
        self.layout.setSpacing(10)
        self.layout.setSizeConstraint(QLayout.SetFixedSize)
        
        self.setLayout(self.layout)

    def accept(self) :
        if self.labelInput.text() == "" :
            self.labelInput.setFocus()
            self.mainWindow.statusBar_.showMessage("The label should not be empty!", 5000)
            qApp.beep()
            logging.getLogger(__name__).warning("The label should not be empty!")
            return
        elif self.labelInput.text() in self.mainWindow.targets.tree.labelList :
            self.labelInput.setFocus()
            self.mainWindow.statusBar_.showMessage("Label already created! Type new one...", 5000)
            qApp.beep()
            logging.getLogger(__name__).warning("Label: '{}' already created! Type new one...".format(self.labelInput.text()))
            return            
        elif self.canIDInput.value() in self.mainWindow.targets.tree.canIDList :
            self.canIDInput.setFocus()
            self.mainWindow.statusBar_.showMessage("CAN ID already created! Choose new one...", 5000)
            qApp.beep()
            logging.getLogger(__name__).warning("CAN ID: [{}] already created! Choose new one...".format(self.canIDInput.value()))
            return
        
        self.data[self.label.text().strip(":")] = self.labelInput.text()
        self.data[self.canID.text().strip(":")] = self.canIDInput.value()
        self.data[self.color.text().strip(":")] = self.colorInput.currentText()
        QDialog.accept(self)
                
#----------------------------------------------------------------------------#