#####################################################
##      Filename:     help_contents_dialog.py      ##
##      Date:         03/08/2020                   ##
##      Author:       Ayman HATOUM                 ##
#####################################################
"""This file contains the class definition of helpContentsDialog(). 
A subclass of QDialog() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import Qt
from PyQt5.QtCore import QUrl
from PyQt5.QtHelp import QHelpEngine
from PyQt5.QtWidgets import QDialog
from PyQt5.QtWidgets import QPushButton
from PyQt5.QtWidgets import QVBoxLayout
from PyQt5.QtWidgets import QTabWidget
from PyQt5.QtWidgets import QSplitter
from src.constants import helpPath
from src.constants import whatsThisMsg 
from src.dialogs.help_browser import helpBrowser

#----------------------------------------------------------------------------#

class helpContentsDialog(QDialog) :
    "Help contents dialog class"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing help contents dialog...")
        super().__init__(parent)

        self.setWindowTitle("Help")
        
        self.helpEngine = QHelpEngine(helpPath+"help.qhc", parent)
        self.helpEngine.setUsesFilterEngine(True)
        self.helpEngine.setupData()
        self.navigator = QTabWidget()
        self.navigator.setWhatsThis(whatsThisMsg.format("Navigator", "Click on the item that you want help with."))
        self.navigator.setMinimumWidth(200)
        self.navigator.setTabPosition(QTabWidget.North)
        self.navigator.addTab(self.helpEngine.contentWidget(), "Contents")
        self.navigator.addTab(self.helpEngine.indexWidget(), "Index")

        self.browser = helpBrowser(self.helpEngine, parent)
        self.browser.setMinimumSize(500, 400)
        self.browser.setSource(QUrl("qthelp://tdcs/doc/contents.html"))

        self.splitter = QSplitter(Qt.Horizontal)
        self.splitter.addWidget(self.navigator)
        self.splitter.addWidget(self.browser)

        self.okButt = QPushButton("OK", self)
        self.okButt.setDefault(True)
        self.okButt.clicked.connect(self.accept)

        self.layout = QVBoxLayout()
        self.layout.addWidget(self.splitter)
        self.layout.addWidget(self.okButt, 0, Qt.AlignRight)
        self.layout.setSpacing(10)
        self.setLayout(self.layout)

    def accept(self) :
        QDialog.accept(self)
                
#----------------------------------------------------------------------------#