#############################################
##      Filename:     help_browser.py      ##
##      Date:         03/08/2020           ##
##      Author:       Ayman HATOUM         ##
#############################################
"""This file contains the class definition of helpBrowser(). 
A subclass of QTextBrowser() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtWidgets import QTextBrowser
from src.constants import whatsThisMsg

#----------------------------------------------------------------------------#

class helpBrowser(QTextBrowser) :
    "Help browser class"
    def __init__(self, helpEngine, parent) :
        logging.getLogger(__name__).debug("Constructing help browser...")
        super().__init__(parent)
        
        self.setWhatsThis(whatsThisMsg.format("Browser", "Here you can browse help description related to the selected item from navigator."))

        self.helpEngine = helpEngine

        self.helpEngine.contentWidget().clicked.connect(self.contentClicked)
        self.helpEngine.indexWidget().linkActivated.connect(self.setSource)

    def contentClicked(self, index) :
        item = self.helpEngine.contentModel().contentItemAt(index)
        self.setSource(item.url())

    def loadResource(self, type, name) :
        if name.scheme() == "qthelp" :
            return self.helpEngine.fileData(name)
        else :
            return QTextBrowser.loadResource(self, type, name)
                
#----------------------------------------------------------------------------#