########################################################
##      Filename:     display_settings_dialog.py      ##
##      Date:         18/09/2020                      ##
##      Author:       Ayman HATOUM                    ##
########################################################
"""This file contains the class definition of displaySettingsDialog(). 
A subclass of QDialog() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtWidgets import QDialog
from PyQt5.QtWidgets import QLabel
from PyQt5.QtWidgets import QComboBox
from PyQt5.QtWidgets import QGridLayout
from PyQt5.QtWidgets import QPushButton
from PyQt5.QtWidgets import QLayout
from PyQt5.QtWidgets import QGroupBox
from PyQt5.QtWidgets import QHBoxLayout
from PyQt5.QtWidgets import QVBoxLayout
from src.constants import nsecResolutions
from src.constants import usecResolutions
from src.constants import msecResolutions
from src.constants import secResolutions
from src.constants import whatsThisMsg

#----------------------------------------------------------------------------#

class displaySettingsDialog(QDialog) :
    "Display settings dialog class"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing display settings dialog...")
        super().__init__(parent)
        
        self.mainWindow = parent
        self.data = {}
        
        self.setWindowTitle("Display Settings")
        
        # self.builderDisplay = QGroupBox("Builder View")
        # self.builderDisplay.setWhatsThis(whatsThisMsg.format("Builder View", "Display of the builder view."))
        
        # self.builderDisplayBox = QGridLayout()
        # self.builderDisplayBox.addWidget(___, 0, 0)
        # self.builderDisplayBox.addWidget(___, 0, 1)
        # self.builderDisplayBox.setSpacing(10)
        # self.builderDisplay.setLayout(self.builderDisplayBox)
        
        timeUnit = self.mainWindow.central.scheduler.schedule.scene.timeUnit
        if timeUnit == "ns" :
            axisResolutions = nsecResolutions
        elif timeUnit == "µs" :
            axisResolutions = usecResolutions
        elif timeUnit == "ms" :
            axisResolutions = msecResolutions
        else :
            axisResolutions = secResolutions

        self.schedulerDisplay = QGroupBox("Scheduler View")
        self.schedulerDisplay.setWhatsThis(whatsThisMsg.format("Scheduler View", "Display of the scheduler view."))

        self.axisRes = QLabel("Axis resolution:", self)
        self.axisResInput = QComboBox(self)
        self.axisResInput.addItems(axisResolutions)
        self.axisResInput.setCurrentText(self.mainWindow.central.scheduler.schedule.scene.axisRes)
        self.axisRes.setWhatsThis(whatsThisMsg.format("Axis Resolution", "Specifies display axis resolution for schedule <strong>timeline</strong>."))
        self.axisResInput.setWhatsThis(whatsThisMsg.format("Axis Resolution", "Specifies display axis resolution for schedule <strong>timeline</strong>."))

        self.schedulerDisplayBox = QGridLayout()
        self.schedulerDisplayBox.addWidget(self.axisRes, 0, 0)
        self.schedulerDisplayBox.addWidget(self.axisResInput, 0, 1)
        self.schedulerDisplayBox.setSpacing(10)
        self.schedulerDisplay.setLayout(self.schedulerDisplayBox)

        self.okButt = QPushButton("OK", self)
        self.okButt.setDefault(True)
        self.okButt.clicked.connect(self.accept)
        self.cancelButt = QPushButton("Cancel", self)
        self.cancelButt.clicked.connect(self.reject)

        self.buttonsLayout = QHBoxLayout()
        self.buttonsLayout.addWidget(self.okButt)
        self.buttonsLayout.addWidget(self.cancelButt)
        self.buttonsLayout.setSpacing(10)

        self.layout = QVBoxLayout()
        self.layout.addWidget(self.schedulerDisplay)
        self.layout.addLayout(self.buttonsLayout)
        self.layout.setSpacing(10)
        self.layout.setSizeConstraint(QLayout.SetFixedSize)
        self.setLayout(self.layout)
        
    def accept(self) :
        self.data[self.axisRes.text().strip(":")] = self.axisResInput.currentText()
        QDialog.accept(self)
                
#----------------------------------------------------------------------------#