#############################################
##      Filename:     about_dialog.py      ##
##      Date:         03/08/2020           ##
##      Author:       Ayman HATOUM         ##
#############################################
"""This file contains the class definition of aboutDialog(). 
A subclass of QDialog() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QDialog
from PyQt5.QtWidgets import QLabel
from PyQt5.QtWidgets import QGridLayout
from PyQt5.QtWidgets import QPushButton
from PyQt5.QtWidgets import QLayout
from PyQt5.QtWidgets import QGroupBox
from PyQt5.QtWidgets import QVBoxLayout
from PyQt5.QtWidgets import QTextEdit
from PyQt5.QtGui import QPixmap
from src.constants import picturesPath
from src.constants import kaiLogo
from src.constants import applicationName
from src.constants import aboutMsg

#----------------------------------------------------------------------------#

class aboutDialog(QDialog) :
    "About dialog class"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing about dialog...")
        super().__init__(parent)
        
        self.setWindowTitle("About")
        self.setWindowFlag(Qt.WindowContextHelpButtonHint, False)
        
        self.kaiLogo = QLabel()
        self.kaiLogo.setPixmap(QPixmap(picturesPath+kaiLogo))
        self.appName = QLabel("<center><font size='+2'><strong>{}</strong></font><br>git version: {}</center>".format(applicationName, parent.version))

        self.generalInfo = QGroupBox("General Info")
        self.generalInfo.setAlignment(Qt.AlignHCenter)

        self.generalInfoLayout = QVBoxLayout()

        self.text = QTextEdit()
        self.text.setReadOnly(True)
        self.text.setText(aboutMsg)
        self.text.setAlignment(Qt.AlignJustify)

        self.generalInfoLayout.addWidget(self.text)
        self.generalInfo.setLayout(self.generalInfoLayout)

        self.okButt = QPushButton("OK", self)
        self.okButt.setDefault(True)
        self.okButt.clicked.connect(self.accept)
        
        self.layout = QGridLayout()
        self.layout.addWidget(self.kaiLogo, 0, 0, Qt.AlignCenter)
        self.layout.addWidget(self.appName, 1, 0, Qt.AlignCenter)
        self.layout.addWidget(self.generalInfo, 2, 0, Qt.AlignCenter)
        self.layout.addWidget(self.okButt, 3, 0, Qt.AlignCenter)
        self.layout.setSpacing(10)
        self.layout.setSizeConstraint(QLayout.SetFixedSize)
        self.setLayout(self.layout)

    def accept(self) :
        QDialog.accept(self)
                
#----------------------------------------------------------------------------#