##########################################
##      Filename:     constants.py      ##
##      Date:         18/04/2020        ##
##      Author:       Ayman HATOUM      ##
##########################################
"""This file contains all the constants defined for the whole
tool."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import os
import math
import datetime

#----------------------------------------------------------------------------#

applicationName = "TDCS - Time-Driven Communication Schedule Planner"
workingDirectory = os.getcwd()+"\\"
picturesPath = workingDirectory+"pictures\\"
dataPath = workingDirectory+"data\\"
targetsPath = dataPath+"targets\\"
configPath = workingDirectory+"config\\"
schemaPath = configPath+"schemas\\"
logPath = configPath+"log\\"
helpPath = configPath+"help\\"

tdcsIcon = "kaiLogo.ico"
kaiLogo = "kaiLogo.png"
newIcon = "new.png"
openIcon = "open.png"
saveIcon = "save.png"
saveAsIcon = "saveAs"
logDebugIcon = "debug.png"
exportScheduleIcon = "export.png"
exitIcon = "exit.png"
removeIcon = "delete.png"
displayIcon = "display.png"
settingsIcon = "settings.png"
zoomInIcon = "plus.png"
zoomOutIcon = "minus.png"
newTargetIcon = "newTarget.png"
selectToolIcon = "select.png"
panToolIcon = "pan.png"
generateIcon = "generate.png"
helpContentsIcon = "help.png"
aboutIcon = "about.png"

displayWidth = 0.7      #percentage of the desktop width display
displayHeight = 0.9     #percentage of the desktop length display

#Graphic items settings
minTaskWidth = 100
minTaskHeight = 70
limitNumberOfPorts = 2

portRadius = 5
spaceBetweenPorts = 10

#Parameters for port types
defaultInt = 0
defaultFloat = 0.0
defaultBool = False
minInt = -99
maxInt = 99
minFloat = -99.0
maxFloat = 99.0

#Drawing parameters
colorInt = "blue" 
colorFloat = "orange"
colorBool = "limegreen"

colorFault = "red"
colorSelection = "gray"

colorNames = ['aqua', 'aquamarine', 'azure', 'beige', 'bisque', 'blueviolet', 
    'brown', 'burlywood', 'cadetblue', 'chartreuse', 'chocolate', 'coral', 
    'cornflowerblue', 'crimson', 'darkblue', 'darkcyan', 'darkgoldenrod', 
    'darkgreen', 'darkkhaki', 'darkmagenta', 'darkolivegreen', 'darkred', 
    'darksalmon', 'darkseagreen', 'darkslateblue', 'darkslategray', 'darkturquoise', 
    'deeppink', 'dodgerblue', 'forestgreen', 'fuchsia', 'gold', 'goldenrod', 
    'greenyellow', 'honeydew', 'hotpink', 'indianred', 'indigo', 'khaki', 'lavender',
    'lavenderblush', 'lawngreen', 'lemonchiffon', 'lightblue', 
    'lightcoral', 'lightcyan', 'lightgreen', 'lightpink', 'lightsalmon', 
    'lightseagreen', 'lightskyblue', 'lightslategrey', 'lightsteelblue', 'lime', 
    'magenta', 'maroon', 'mediumaquamarine', 'mediumblue', 'mediumorchid', 
    'mediumpurple', 'mediumseagreen', 'mediumslateblue', 'mediumspringgreen', 
    'mediumturquoise', 'mediumvioletred', 'midnightblue', 'mistyrose', 'moccasin', 
    'navy', 'olive', 'olivedrab', 'orangered', 'orchid', 'palegoldenrod', 'palegreen', 
    'paleturquoise', 'palevioletred', 'papayawhip', 'peachpuff', 'peru', 'pink', 'plum', 
    'powderblue', 'purple', 'rosybrown', 'royalblue', 'saddlebrown', 'salmon', 
    'sandybrown', 'seagreen', 'sienna', 'silver', 'skyblue', 'slateblue', 'slategrey', 
    'springgreen', 'steelblue', 'tan', 'teal', 'thistle', 'tomato', 'turquoise', 
    'violet', 'wheat', 'yellow', 'yellowgreen']

#Preference settings
canBaudRates = ["125 Kbps", "250 Kbps", "500 Kbps", "1 Mbps"]
defaultBaudRate = canBaudRates[3]
timeUnits = ["ns", "µs", "ms", "s"]
defaultTimeUnit = timeUnits[1]
slotRoutines = ["Fixed", "Variable"]
deafaultSlotRoutine = slotRoutines[1]
defaultSlotBuff = 0
defaultSlotOverlapBound = 0
defaultRoundBuff = 0
nsecResolutions = ["1 ns", "10 ns", "100 ns", "1 µs"]
usecResolutions = ["10 ns", "100 ns", "1 µs", "10 µs", "100 µs", "1 ms"]
msecResolutions = ["10 µs", "100 µs", "1 ms", "10 ms", "100 ms", "1 s"]
secResolutions = ["10 ms", "100 ms", "1 s", "10 s", "100 s"]
defaultAxisRes = "1 µs"

#Scheduler scene parameters
taskTimelineHeight = 40
targetTimelineHeight = 60

tickLength = 20
marginLength = 50
smallTickHeight = 5
bigTickHeight = 10
arrowBaseHalf = 20*(math.sqrt(2)/2)

#Tx parameters
intBytes = 4
floatBytes = 4
boolBytes = 1

#Logging
startupMsg = "="*80+"\n="+applicationName.center(78)+"=\n="+datetime.datetime.now().strftime("%a, %d/%m/%Y - %H:%M:%S").center(78)+"=\n"+"="*80

#About
aboutMsg = """This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details. 

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA."""

#WhatIsThis
whatsThisMsg = "<strong>{}</strong><p align='justify'>{}</p>"

#----------------------------------------------------------------------------#