#########################################
##      Filename:     tool_bar.py      ##
##      Date:         18/04/2020       ##
##      Author:       Ayman HATOUM     ##
#########################################
"""This file contains the class definition of toolBar(). A subclass
of QToolBar() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtWidgets import QToolBar
from PyQt5.QtWidgets import QPushButton
from src.constants import whatsThisMsg

#----------------------------------------------------------------------------#

class toolBar(QToolBar) :
    "Main tool bar class"
    def __init__(self, parent, actions) :
        logging.getLogger(__name__).debug("Constructing main tool bar...")
        super().__init__("Main tool bar", parent)

        self.setMovable(False)
        self.setMaximumHeight(25)

        self.addAction(actions.newAction)
        self.addAction(actions.openAction)
        self.addAction(actions.saveAction)
        self.addAction(actions.saveAsAction)
        self.addAction(actions.exportScheduleAction)
        self.addSeparator()
        self.addAction(actions.logDebugAction)
        self.addSeparator()
        self.addAction(actions.newTargetAction)
        self.addAction(actions.removeSelectedAction)
        self.addSeparator()
        self.addAction(actions.selectToolAction)
        self.addAction(actions.panToolAction)
        self.addSeparator()
        self.addAction(actions.generateAction)
        self.addSeparator()
        self.addAction(actions.zoomInAction)
        self.zoomButt = QPushButton("100%")
        self.zoomButt.clicked.connect(parent.resetZoom)
        self.zoomButt.setToolTip("Reset Zoom")
        self.zoomButt.setWhatsThis(whatsThisMsg.format("Reset Zoom", "Use this command to reset zoom wether on builder's or schedule's scene. You can access it from <strong>View Menu</strong> | <strong>Tool Bar</strong>."))
        self.zoomButt.setMaximumWidth(35)
        self.addWidget(self.zoomButt)
        self.addAction(actions.zoomOutAction)

    def updateZoomButt(self, value) :
        self.zoomButt.setText("{}%".format(value))

#----------------------------------------------------------------------------#