###########################################
##      Filename:     status_bar.py      ##
##      Date:         18/04/2020         ##
##      Author:       Ayman HATOUM       ##
###########################################
"""This file contains the class definition of statusBar(). A subclass
of QStatusBar() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QStatusBar
from PyQt5.QtWidgets import QLabel
from PyQt5.QtWidgets import QFrame

#----------------------------------------------------------------------------#

class statusBar(QStatusBar) :
    "Status bar class"
    def __init__(self, parent) :
        logging.getLogger(__name__).debug("Constructing status bar...")
        super().__init__(parent)
        self.setSizeGripEnabled(False)
        self.setMaximumHeight(20)
        
        self.permanentLabel = QLabel("git version : " + parent.version, self)
        self.permanentLabel.setAlignment(Qt.AlignCenter)
        self.permanentLabel.setMargin(20)
        self.addPermanentWidget(self.permanentLabel)
        
        self.permanentEmptyFrame = QFrame(self)
        self.permanentEmptyFrame.setFixedWidth(20)
        self.addPermanentWidget(self.permanentEmptyFrame)

#----------------------------------------------------------------------------#