#########################################
##      Filename:     menu_bar.py      ##
##      Date:         18/04/2020       ##
##      Author:       Ayman HATOUM     ##
#########################################
"""This file contains the class definition of menuBar(). A subclass
of QMenuBar() from PyQt5."""

__author__ = "KAI"

#----------------------------------------------------------------------------#

###############
##  Imports  ##
###############
import logging
from PyQt5.QtWidgets import QMenuBar

#----------------------------------------------------------------------------#

class menuBar(QMenuBar) :
    "Menu bar class"
    def __init__(self, parent, actions) :
        logging.getLogger(__name__).debug("Constructing menu bar...")
        super().__init__(parent)
        
        self.fileMenu = self.addMenu("&File")
        self.editMenu = self.addMenu("&Edit")
        self.viewMenu = self.addMenu("&View")
        self.insertMenu = self.addMenu("I&nsert")
        self.toolsMenu = self.addMenu("T&ools")
        self.addSeparator()
        self.helpMenu = self.addMenu("&Help")
        
        self.createFileMenu(actions)
        self.createEditMenu(actions)
        self.createViewMenu(actions)
        self.createInsertMenu(actions)
        self.createToolsMenu(actions)
        self.createHelpMenu(actions)
    
    def createFileMenu(self, actions) :
        logging.getLogger(__name__).debug("Creating file menu...")
        # self.fileMenu.setMinimumWidth(400)
        self.fileMenu.addAction(actions.newAction)
        self.fileMenu.addAction(actions.openAction)
        self.fileMenu.addAction(actions.saveAction)
        self.fileMenu.addAction(actions.saveAsAction)
        self.fileMenu.addSeparator()
        self.fileLogMenu = self.fileMenu.addMenu("&Log")
        self.fileLogMenu.addAction(actions.logDebugAction)
        self.fileExportMenu = self.fileMenu.addMenu("E&xport")
        self.fileExportMenu.addAction(actions.exportScheduleAction)
        self.fileExportMenu.addAction(actions.exportScheduleDescriptionAction)
        self.fileMenu.addSeparator()
        self.fileMenu.addAction(actions.exitAction)
    
    def createEditMenu(self, actions) :
        logging.getLogger(__name__).debug("Creating edit menu...")
        self.editMenu.addAction(actions.removeSelectedAction)
        self.editMenu.addSeparator()
        self.editMenu.addAction(actions.displaySettingsAction)
        self.editMenu.addAction(actions.prefSettingsAction)
    
    def createViewMenu(self, actions) :
        logging.getLogger(__name__).debug("Creating view menu...")
        self.viewMenu.addAction(actions.zoomInAction)
        self.viewMenu.addAction(actions.zoomOutAction)
        self.viewMenu.addAction(actions.resetZoomAction)
    
    def createInsertMenu(self, actions) :
        logging.getLogger(__name__).debug("Creating insert menu...")
        self.insertMenu.addAction(actions.newTargetAction)
        
    def createToolsMenu(self, actions) :
        logging.getLogger(__name__).debug("Creating tools menu...")
        self.toolsMenu.addAction(actions.selectToolAction)
        self.toolsMenu.addAction(actions.panToolAction)
        self.toolsMenu.addSeparator()
        self.toolsMenu.addAction(actions.generateAction)
        
    def createHelpMenu(self, actions) :
        logging.getLogger(__name__).debug("Creating help menu...")
        self.helpMenu.addAction(actions.onItemAction)
        self.helpMenu.addAction(actions.helpContentsAction)
        self.helpMenu.addSeparator()
        self.helpMenu.addAction(actions.aboutAction)

#----------------------------------------------------------------------------#