def hb_read(fname):

    with open(fname) as f:
        lines = [[x for x in line.split()] for line in f]

    # matrix dimension 
    dim = int(lines[2][1])
    numel = int(lines[2][3])

    # change 'D' in 'E', scientific notation
    for i in range(4, len(lines)):
        try:
            if lines[i][0][-4] == 'D':
                s = list(lines[i][0])
                s[-4] = 'E'
                lines[i][0] = ''.join(s)
        except:
            pass

    lines = [float(lines[i][0]) for i in range(4, len(lines))]

    section1 = []
    section2 = []
    values = []

    for i in range(len(lines)):
        if i <= dim:
            section1.append(int(lines[i]))
        elif i > dim and i <= dim + numel:
            section2.append(int(lines[i]))
        elif i > dim + numel and i <= dim + 2 * numel:
            values.append(float(lines[i]))


    mat = [[0 for i in range(dim)] for j in range(dim)]

    for i in range(len(section1) - 1):
        for j in range(section1[i] - 1, section1[i + 1] - 1):
            mat[i][section2[j] - 1] = values[j]

    for i in range(len(mat)):
        for j in range(i, len(mat)):
            if i != j:
                mat[j][i] = mat[i][j]
    return mat

def mapping(fname):
    with open(fname) as f:
        mat = [[x for x in line.split()] for line in f]

    for i in range(len(mat)):
        if mat[i][2] == 'UX':
            mat[i][2] = 1
        elif mat[i][2] == 'UY':
            mat[i][2] = 2
        elif mat[i][2] == 'UZ':
            mat[i][2] = 3
        
    mat_mapping = tuple(
        map(
            tuple, [
                [
                    int(mat[i][j])
                    for j in range(len(mat[1]))
                    ] for i in range(1,len(mat)
                )
            ]
        )
    )

    return mat_mapping

def contact_nodes_id(fname, ansys_id):
    mat_mapping = mapping(fname)

    nodes_id = tuple([i[0] - 1 for i in mat_mapping 
                      if i[1] in ansys_id])

    return nodes_id


