from funk import matrix_extraction, ordinate_matrix, stick_contact_cs
from model import Contact, Solution
from harwell_boeing_read import contact_nodes_id

# Extract M, C, K from external .txt file (Harwell-Boeing format)
Fn = ((25, 1.),)                # [q, F] dof e forza associata
M_directory = 'M.txt'
K_directory = 'K.txt'
M, C, K, Fef = matrix_extraction(M_directory, K_directory, Fn)

# Define contact dof(s)
ansys_id=  [3596, 3598, 3599, 3601, 3608, 3609, 3612, 3613]
Contact_dof = contact_nodes_id('matrix.mapping', ansys_id)
Contact_dof_r = [Contact_dof[i] for i in range(len(Contact_dof)//2)]
Contact_dof_l = [Contact_dof[i] for i in (18, 19, 20, 12, 13, 14, 
                                          21, 22, 23, 15, 16, 17)]

# Non-linear solution options
freq_range = [50, 100, .2]  # frequency range: [min, max, step]
nH = 2                      # Number of harmonics
rev = True                  # Frequencies order --> 0: ascending, 1: descending
startstick = True           # Initial value for fsolve --> 0: slip solution, 1: stick solution
dof = 24                    # which dof to plot

# Cyclic symmetry options
cs = False                  # True(1): on, False(0): off
N = 40                      # Number of blades
num_of_freq = 4             # number of natural frequencies to plot

# Define contact properties
Kt = 3e5                    # Tangential contact stiffness.
Kn = Kt                     # Normal contact stiffness.
mu = 0.5                    # Friction coefficient.
N0tot = [1, 2.5, 5, 10, 15, 25]# Contact normal load
N0 = tuple(
    [
         0 if len(Contact_dof) == 0 
         else N0tot[i]/len(Contact_dof) 
         for i in range(len(N0tot))
         ]
    )

# Define contact object 
con = Contact(Contact_dof_r, Contact_dof_l, Kt, Kn, mu, nH)

# Ordinate M, C, K and Fef (contact dof first, other nodes, modes)
M, C, K, Fef = ordinate_matrix(M, C, K, Fef, contact_properties = con)

#Linear solution - full-slip and full-stick 
sol = Solution(M, C, K, Fef, freq_range, con, rev, cs)
sol.plot_linear(dof)

#------------------------------------------------------------------------------
# NON-LINEAR SOLUTION
    
sol_container = []
fn_container = []
if cs == True:
    # full-stick solution in cyclic symmetry
    sol_stick_cs = stick_contact_cs(sol, con, N, num_of_freq)
    for i in range(len(N0)):
        n0 = N0[i]
        con.N0 = n0
        for h in range(N//2 + 1):
            sol_container.append(
                Solution(M, C, K, Fef, freq_range, con, rev, cs)
                )
            sol_container[i].nonlinear_solution(con, startstick, N, h)
            fn_container.append(sol_container[i].get_result(dof))
            sol_container[i].plot_nonlinear(N0tot[i], dof)            
            
else:
    for i in range(len(N0)):
        con.N0 = N0[i]
      
        sol_container.append(
            Solution(M, C, K, Fef, freq_range, con, rev)
            )
        sol_container[i].nonlinear_solution(con, startstick = 1)
        sol_container[i].plot_nonlinear(N0tot[i], dof)
        sol_container[i].get_result(dof)
    
