quantili <- seq(from=0.2,to=1.0,by=0.2)
outcome <- "G3"
customGreen0 = "#DeF7E9"

customGreen = "#71CA97"

customRed = "#ff7f7f"

sign_formatter <- formatter("span", 
                            style = x ~ style(color = ifelse(x > 0, "green", 
                                                             ifelse(x < 0, "red", "black"))))
unit.scale <- function(x) (x - min(x)) / (max(x) - min(x))

colorbar <- function(color = "lightgray", fun = "comma", digits = 0) {
  fun <- match.fun(fun)
  formatter("span", x ~ fun(x, digits = digits),
            style = function(y) style(
              display = "inline-block",
              direction = ifelse(y > 0, "rtl","ltr") ,
              "border-radius" = "4px",
              "padding-right" = "2px",
              "background-color" = ifelse(y > 0, csscolor(color),customRed) ,
              width = percent(proportion(as.numeric(y))),
              "font-weight" = ifelse(y == max(y), "bold", NA)
            )
  )
}

mapptype <- function(x){
 LETTERS[match(x,tipi)]
}

brunori_bernstein <- function(hr){
  
  tipi = unique(hr$node_placement)
  
  ### creo un dataframe per ospitare i gradi trovati relativi ai tipi
  grado <- c(1:length(tipi))*0
  info = data.frame(tipi,grado)
  
  for(k in tipi) {
    
    ### seleziono il subset del tipo k
    y = hr[hr$node_placement == k,]
    
    # definisco il numero di fold
    f_max = 5
    # creo i fold in modo che siano bilanciati per la variabile di factor
    folds <- createFolds(factor(y[[outcome]]), k = f_max, list = FALSE)
    # assegno ad ogni riga il valore del rispettivo fold di appartenenza
    y$fold = folds
    
    # scelgo un range di gradi del polinomio tra provare
    range_b = 1:10
    # faccio un vettore per ospitare le rispettive likelihood
    LLs <- c(range_b)*0
    
    ### b  il grado del polinomio approssimatore di bernstein
    for(b in range_b){
      
      range_f = 1:f_max
      # faccio un vettore che ospita le likelihood per ogni grado
      LLsb <- c(range_f)*0
      
      ordine <- b
      
      for(f in range_f){
        
        trainData = y[y$fold != f,]
        trainData <- trainData[[outcome]]
        testData = y[y$fold == f,]
        testData <-testData[[outcome]]
        
        eCDF <- ecdf(trainData)
        
        m <- min(trainData)
        M <- max(trainData)
        
        m_test <- min(testData)
        M_test <- max(testData)
        
        # riporta il dominio della eCDF del train tra 0 e 1
        Fy <- function(y){
          b <- M
          a <- m
          eCDF((M-m)*y+m)
        }
        
        ### stimo i coefficienti di bernstein approssimando la CDF del training set
        bc = bernstein(Fy, dims = 1, k = ordine)
        ### coefficienti estratti dal polinomio di bernstein calcolato sul training set
        cf <- bc$coeffs
        
        ### set-up basis - il primo argomento dev'essere un tipo 'numeric_var'
        bb <- Bernstein_basis(numeric_var("x", support = c(m_test, M_test)), 
                              order = ordine, ui = "increasing")
        
        x <- sort(testData)
        xx <- as.data.frame(x)
        LLsb[f] = sum(log(predict(bb, newdata = xx, coef = cf, deriv = c(x = 1))))
      }
      LLs[b] = sum(LLsb)
    }
    
    ### massima likelihood calcolata
    max_b = max(LLs)
    ### indice di LLs dove si trova la massima likelihood
    grado_m = match(max_b,LLs)
    ### assegna quell'indice al tipo relativo -  il grado del polinomio
    info[info$tipi == k,]$grado = grado_m
  }
  return (info)
}
giveme_x <- function(z) {
  x <- sort(z)
  xx <- as.data.frame(x)
  return (xx)
} 
normalize_var <- function(array, x, y){
  # Normalize to [0, 1]:
  m = min(array)
  range = max(array) - m
  array = (array - m) / range
  
  # Then scale to [x,y]:
  range2 = y - x
  normalized = (array*range2) + x
  return (round(normalized,3))
}

### restituisce la CDF della distribuzione x stimata secondo Bernstein con il grado m
bern_app <- function(x,m){
  
  # distribuzione di cui stimare la Bernstein(CDF)
  z <- x
  
  Fz <- ecdf(z)
  
  # funzione tra 0 e 1 da dare in input a bernstein
  f <- function(y){
    ### FF funzione da calcolare
    ### z dominio di FF
    ### y punto/i dove calcolare FF
    FF <- Fz
    z <- z
    
    b <- max(z)
    a <- min(z)
    FF((b-a)*y+a)
  }
  
  cf <- bernstein(f, dims = 1, k = m)$coeffs
  bb <- Bernstein_basis(numeric_var("x", support = c(min(z), max(z))), 
                        order = m, ui = "increasing")
  
  newList <- list("basis" = bb, "cf" = cf)
  
  return (newList)
}

bern_app2 <- function(x,m){
  
  # distribuzione di cui stimare la Bernstein(CDF)
  z <- x
  
  Fz <- ecdf(z)
  
  # funzione tra 0 e 1 da dare in input a bernstein
  f <- function(y){
    ### FF funzione da calcolare
    ### z dominio di FF
    ### y punto/i dove calcolare FF
    FF <- Fz
    z <- z
    
    b <- max(z)
    a <- min(z)
    FF((b-a)*y+a)
  }
  
  cf <- bernstein(f, dims = 1, k = m)$coeffs
  bb <- Bernstein_basis(numeric_var("x", support = c(min(z), max(z))), 
                        order = m, ui = "increasing")
  
  x <- sort(z)
  xx <- as.data.frame(x)
  
  predict(bb, newdata = xx, coef = cf)
}

brunori_outcome <- function(df, info){
  hr <- df
  hr$quantile <- 0
  tipi = info$tipi
  
  for(k in tipi) {
    ### seleziono il subset del tipo k
    y <- hr[hr$node_placement == k,]
    m <- info[info$tipi == k,]$grado
    
    dioaiuto <- function(x){
      yy <- y[[outcome]]
      ba <- bern_app(yy, m)
      round(predict(ba$basis, newdata = giveme_x(x), coef = ba$cf),digits = 2)
    }
    
    ecdfs <- c(1:length(y[[outcome]]))*0
    for (i in 1:length(y[[outcome]])){
      yy <- y[[outcome]]
      a <- dioaiuto(yy[i])
      ecdfs[i] <- a
    }
    y$cdf <- ecdfs
    
    last_quant <- -1
    h <- 1
    for(quantile in quantili){
      
      hr[ rownames(y[(y$cdf > last_quant) & (y$cdf <= quantile),]),]$quantile <- h
      last_quant <- quantile
      h <- h+1
    }
    
  }
  
  # PER OGNI TIPO 
  # per ogni quantile 
  # selezionare outcome (Age)
  # calcolare la media di outcome per tutta la popolazione
  # calcolare all'interno del quantile la media dell'outcome
  
  mu <- mean(hr[[outcome]])
  media_k_q <-c(1:length(tipi))*0
  medie_q <-c(1:length(quantili))*0
  
  for(quantile in 1:5) {
    hh <- hr[hr$quantile == quantile,]
    medie_q[quantile] <- mean(hh[[outcome]])
  }
  
  hr$outcome <- 0
  
  for(k in tipi){
    for (quantile in 1:5){
      hh <- hr[(hr$node_placement == k)  & (hr$quantile == quantile),]
      y <- hh[[outcome]]
      hr[(hr$node_placement == k)  & (hr$quantile == quantile),]$outcome <- y* (mu/medie_q[quantile])
    }
  }
  return(hr)
}

metodo_brunori <- function(df) {
  info <- brunori_bernstein(df)
  df <- brunori_outcome(df,info)
  ml <- list("info" = info, "df" = df)
  return(ml)
}

ranking_top <- function(df, sortby) {
  ord_hr <- df[order(-df[[sortby]]),]
  
  top500 <- head(ord_hr,500)
  top250 <- head(ord_hr,250)
  top100<- head(ord_hr,100)
  
  newList <- list("top100" = top100, "top250" = top250, "top500"=top500)
  
  return (newList)
}

rank_equity <- function (df, k) {
  test4 <- df[order(-df$outcome),]
  
  num_groups = 50
  
  subsets <- test4 %>% 
    group_by((row_number()-1) %/% (n()/num_groups)) %>%
    nest %>% pull(data)
  
  subsets <- lapply(subsets, function(set){
    setDT(set)[, mean_outcome_type := mean(outcome), by = node_placement]
  })
  
  l2<-lapply(subsets, function(x) 
    cbind(x, outcome_1 = mean(x$mean_outcome_type)))
  
  equal <- rbindlist(l2)
  equal$mean_outcome_type <- NULL
  
  equal$outcome_std <- equal$outcome
  equal$outcome <- equal$outcome_1
  equal$outcome_1 <- NULL
  equal <- equal[order(-equal$outcome),]
  
  
  return(head(equal,k))
  
}

rank_equality <- function(df, column, k) {
  classi <- unique(df[[column]])
  len <- length(classi)
  size <- k/len
  
  df$outcome_std <- df$outcome
  
  df %>% 
    arrange(desc(G3)) %>% 
    group_by(sex) %>% slice(1:size) %>% 
    arrange(desc(G3)) 
}

rank_needing <- function(df, column, k) {
  classi <- unique(df[[column]])
  len <- length(classi)
  size <- k/len
  
  test4 <- df[order(-df$outcome),]
  
  num_groups = 50
  
  subsets <- test4 %>% 
    group_by((row_number()-1) %/% (n()/num_groups)) %>%
    nest %>% pull(data)
  
  subsets <- lapply(subsets, function(set){
    setDT(set)[, mean_outcome_type := mean(outcome), by = node_placement]
  })
  
  l2<-lapply(subsets, function(x) 
    cbind(x, outcome_1 = mean(x$mean_outcome_type)))
  
  equal <- rbindlist(l2)
  equal$mean_outcome_type <- NULL
  
  equal$outcome_std <- equal$outcome
  equal$outcome <- equal$outcome_1
  equal$outcome_1 <- NULL
  equal <- equal[order(-equal$outcome),]
  
  equal %>% 
    arrange(desc(outcome)) %>% 
    group_by(sex) %>% slice(1:size) %>% arrange(desc(outcome)) 
}

ranking_equality <- function(df, group) {
  classi <- unique(df[[group]])
  len <- length(classi)
  dfs <- c(1:len)*0
  
  i <- 1
  for(classe in classi){
    d <- df[df[[group]] == classe,]
    d <- d[order(-d[[outcome]]),]
    dfs[i] <- d
    i <- i+1
  }
  
  top500 <- head(dfs[1], 500/len)
  
  top500 <- rbind(head())
  
  top500 <- head(ord_hr,500)
  top250 <- head(ord_hr,250)
  top100<- head(ord_hr,100)
  
  newList <- list("top100" = top100, "top250" = top250, "top500"=top500)
  
  return (newList)
}

olp_table <- function(olp) {
  d <- olp$depr$deprivati
  ds <- olp$depr_std$deprivati_std
  f <- olp$fort$fortunati
  fs <- olp$fort_std$fortunati_std
  
  Deprivati <- levels(d)[as.numeric(d)]
  Deprivati_standard <- levels(ds)[as.numeric(ds)]
  Privilegiati <- levels(f)[as.numeric(f)]
  Privilegiati_standard <- levels(fs)[as.numeric(fs)]
  
  df1 <- data.frame(Deprivati, Deprivati_standard, Privilegiati,Privilegiati_standard,stringsAsFactors=FALSE )
  
  return(df1)
}

reward_profile <- function(df){
  
  hr <- df
  tipi = unique(hr$node_placement)
  ### avremo un tipo maggiormente deprivato per ogni quantile
  deprivati <- c(1:length(quantili))*0
  deprivati_std <- c(1:length(quantili))*0
  fortunati <- c(1:length(quantili))*0
  fortunati_std <- c(1:length(quantili))*0
  
  for(quantile in 1:length(quantili)){
    
    ### calcoliamo un outcome medio per ogni tipo
    outcomes <- c(1:length(tipi))*0
    outcomes_std <- c(1:length(tipi))*0
    
    for (k in tipi){
      ### inseriamo il valore medio alla posizione corrispondente
      ### NB: l'indice del valore inserito in outcomes == indice di k in "tipi"
      outcomes_std[which(k == tipi)] <- mean(hr[which(hr$node_placement == k),]$outcome)
      
      d <- hr[which(hr$node_placement == k),]
      outcomes[which(k == tipi)] <- mean(d[[outcome]])
      
    }
    ### dagli outcome calcolati estraiamo il minore e ricaviamo il suo indice 
    indicetipominore <- match(min(outcomes),outcomes)
    indicetipominore_std <- match(min(outcomes_std),outcomes_std)
    
    indicetipomaggiore <- match(max(outcomes),outcomes)
    indicetipomaggiore_std <- match(max(outcomes_std),outcomes_std)
    
    ### questo indice  uguale a quello del tipo da cui proviene rispetto a "tipi"
    tipo1 <- tipi[indicetipominore]
    tipo2 <- tipi[indicetipominore_std]
    tipo3 <- tipi[indicetipomaggiore]
    tipo4 <- tipi[indicetipomaggiore_std]
    
    deprivati[quantile] <- tipo1
    deprivati_std[quantile] <- tipo2
    fortunati[quantile] <- tipo3
    fortunati_std[quantile] <- tipo4
  }
  
  depr <- data.frame(table(deprivati))
  depr <- depr[order(depr$Freq),]
  
  depr_std <- data.frame(table(deprivati_std))
  depr_std <- depr_std[order(depr_std$Freq),]
  
  fort <- data.frame(table(fortunati))
  fort <- fort[order(fort$Freq),]
  
  fort_std <- data.frame(table(fortunati_std))
  fort_std <- fort_std[order(fort_std$Freq),]
  
  newList <- list("depr" = depr, "depr_std" = depr_std, "fort"=fort, "fort_std"=fort_std)
  
  return (newList)
}

opportunity_lossprofile <- function(df){
  
  hr <- df
  tipi = unique(hr$node_placement)
  ### avremo un tipo maggiormente deprivato per ogni quantile
  deprivati <- c(1:length(quantili))*0
  deprivati_std <- c(1:length(quantili))*0
  fortunati <- c(1:length(quantili))*0
  fortunati_std <- c(1:length(quantili))*0
  
  for(quantile in 1:length(quantili)){
    
    ### calcoliamo un outcome medio per ogni tipo
    outcomes <- c(1:length(tipi))*0
    outcomes_std <- c(1:length(tipi))*0
    
    for (k in tipi){
      ### inseriamo il valore medio alla posizione corrispondente
      ### NB: l'indice del valore inserito in outcomes == indice di k in "tipi"
      outcomes_std[which(k == tipi)] <- mean(hr[which(hr$node_placement == k),]$outcome_std)
      
      d <- hr[which(hr$node_placement == k),]
      outcomes[which(k == tipi)] <- mean(d[[outcome]])
      
    }
    ### dagli outcome calcolati estraiamo il minore e ricaviamo il suo indice 
    indicetipominore <- match(min(outcomes),outcomes)
    indicetipominore_std <- match(min(outcomes_std),outcomes_std)
    
    indicetipomaggiore <- match(max(outcomes),outcomes)
    indicetipomaggiore_std <- match(max(outcomes_std),outcomes_std)
    
    ### questo indice  uguale a quello del tipo da cui proviene rispetto a "tipi"
    tipo1 <- tipi[indicetipominore]
    tipo2 <- tipi[indicetipominore_std]
    tipo3 <- tipi[indicetipomaggiore]
    tipo4 <- tipi[indicetipomaggiore_std]
    
    deprivati[quantile] <- tipo1
    deprivati_std[quantile] <- tipo2
    fortunati[quantile] <- tipo3
    fortunati_std[quantile] <- tipo4
  }
  
  depr <- data.frame(table(deprivati))
  depr <- depr[order(depr$Freq),]
  
  depr_std <- data.frame(table(deprivati_std))
  depr_std <- depr_std[order(depr_std$Freq),]
  
  fort <- data.frame(table(fortunati))
  fort <- fort[order(fort$Freq),]
  
  fort_std <- data.frame(table(fortunati_std))
  fort_std <- fort_std[order(fort_std$Freq),]
  
  newList <- list("depr" = depr, "depr_std" = depr_std, "fort"=fort, "fort_std"=fort_std)
  
  return (newList)
}

stampa_olp <- function(rk_list, reward = FALSE) {
  
  ranking <- names(rk_list)
  deprived <- c(1:length(rk_list))
  deprived_std <- c(1:length(rk_list))
  privileged <- c(1:length(rk_list))
  privileged_std <- c(1:length(rk_list))
  h <- 1
  if(reward){
    for(rk in rk_list) {
      o <- olp_table(reward_profile(rk))
      deprived[h] <- o$Deprivati
      deprived_std[h] <- o$Deprivati_standard 
      privileged[h] <- o$Privilegiati 
      privileged_std[h] <- o$Privilegiati_standard
      h <- h + 1
    }
  }else {
    for(rk in rk_list) {
      o <- olp_table(opportunity_lossprofile(rk))
      deprived[h] <- o$Deprivati
      deprived_std[h] <- o$Deprivati_standard 
      privileged[h] <- o$Privilegiati 
      privileged_std[h] <- o$Privilegiati_standard
      h <- h + 1
    }
  }
  
  info <- data.frame(ranking,deprived,deprived_std,privileged,privileged_std,stringsAsFactors=FALSE)
  names(info) <- c("Ranking","Disadvantaged", "Disadvantaged (after)", "Advantaged", "Advantaged (after)")
  formattable(info, 
              align =c("l","r", "l","r","l"),
              list(
                'Disadvantaged (after)' = formatter(
                  "span",
                  style = ~style(color= ifelse( `Disadvantaged` == `Disadvantaged (after)`, "black","green"),
                                 "font-weight"= ifelse( `Disadvantaged` == `Disadvantaged (after)`, NA,"bold"))),
                
                'Advantaged (after)' = formatter(
                  "span",
                  style = ~style(color= ifelse( `Advantaged` == `Advantaged (after)`, "black","green"),
                                 "font-weight"= ifelse( `Advantaged` == `Advantaged (after)`, NA,"bold")))
                )
              )
              
}

reward_rate <- function(df) {
  
  hr <- df
  tipi = unique(hr$node_placement)
  
  hr$OpportunityLossRate <- 0
  
  ### Opportunity Loss Rate
  for (k in tipi){
    om <- mean(hr[which(hr$node_placement == k),][[outcome]])
    oms <- mean(hr[which(hr$node_placement == k),][["outcome"]])
    
    index <- hr$node_placement == k
    hr$OpportunityLossRate[index] <- round(oms - om,3)
    
    #hr[hr$node_placement == k,][[OpportunityLossRate]] <- round(om - oms,3)
    
    # info[which(info$tipi == k),]$outcome_medio <- round(om,3)
    # info[which(info$tipi == k),]$outcome_medio_standard <- round(oms,3)
    # v <- om- oms
    # info[which(info$tipi == k),]$variazione_outcome <- v
  }
  
  ### normalizziamo la variazione di outcome calcolata
  hr$OpportunityLossRate <- normalize_var(hr$OpportunityLossRate,-1,1)
  return(hr)
}

opportunity_lossrate <- function(df) {
  
  hr <- df
  tipi = unique(hr$node_placement)
  
  hr$OpportunityLossRate <- 0
  
  ### Opportunity Loss Rate
  for (k in tipi){
    om <- mean(hr[which(hr$node_placement == k),][[outcome]])
    oms <- mean(hr[which(hr$node_placement == k),][["outcome_std"]])
    
    index <- hr$node_placement == k
    hr$OpportunityLossRate[index] <- round(oms - om,3)
    
    #hr[hr$node_placement == k,][[OpportunityLossRate]] <- round(om - oms,3)
    
    # info[which(info$tipi == k),]$outcome_medio <- round(om,3)
    # info[which(info$tipi == k),]$outcome_medio_standard <- round(oms,3)
    # v <- om- oms
    # info[which(info$tipi == k),]$variazione_outcome <- v
  }
  
  ### normalizziamo la variazione di outcome calcolata
  hr$OpportunityLossRate <- normalize_var(hr$OpportunityLossRate,-1,1)
  return(hr)
}

stampa_olr <- function(rk_list, reward = FALSE) {
  ranking <- names(rk_list)
  olr_df <- NULL
  
  if(reward){
    olr_df <- lapply(rk_list, function(df){
      r <- reward_rate(df)
      r <- r[!duplicated(r$node_placement),]
      olr <- data.frame(r$node_placement, r$OpportunityLossRate)
      colnames(olr) <- c('Type','OpportunityLossRate')
      return (olr)
    })
    h <- 1
    for(name in ranking) {
      colnames(olr_df[[h]]) <- c('Type',paste0('RR_',name))
      h <- h+ 1
    }
  }else{
    olr_df <- lapply(rk_list, function(df){
      r <- opportunity_lossrate(df)
      r <- r[!duplicated(r$node_placement),]
      olr <- data.frame(r$node_placement, r$OpportunityLossRate)
      colnames(olr) <- c('Type','OpportunityLossRate')
      return (olr)
    })
    h <- 1
    for(name in ranking) {
      colnames(olr_df[[h]]) <- c('Type',paste0('OLR_',name))
      h <- h+ 1
    }
  }
  
  rbl <- rbindlist(olr_df, fill = TRUE)
  rbl <- rbl %>%
    group_by(Type) %>%
    summarise_each(funs(mean(., na.rm = TRUE)))
  
  df <- rbl
  print(
    formattable(df,
      list(formattable::area(col = 2:(length(rk_list)+1)) ~ color_tile(customRed, "lightblue"),
           
           Type = formatter("span", style = ~ style(color = "black",font.weight = "bold")))
    )
  )
}

calcolo_ineq <- function(df,name) {
  ### CALCOLO INEQ
  #print(ineq(df$outcome, type="Gini"))
  
  plot(Lc(df$outcome),col="orange",lwd=2,main = paste0("Lorent Curve for ",name))
  #print(ineq(df[[outcome]], type="Gini"))
  #par(new = TRUE)
  lines(Lc(df[[outcome]]),col="blue",lwd=2, lty = 2)
  legend("topleft", legend=c("Outcome std", "Outcome before"),
         col=c("orange", "blue"), lty=1:2,cex = 0.7, horiz = TRUE)
}

stampa_ineq <- function(rk_list) {
  ranking <- names(rk_list)
  Gini_before <- c(1:length(rk_list))
  Gini_after <- c(1:length(rk_list))
  h <- 1
  par(mfrow=c(3,2))
  for(rk in rk_list) {
    calcolo_ineq(rk, ranking[h])
    Gini_after[h] <- round(ineq(rk$outcome, type="Gini"),3)
    Gini_before[h] <- round(ineq(rk[[outcome]], type="Gini"),3)
    h <- h + 1
  }

  info <- data.frame(ranking,Gini_before,Gini_after)
  info$delta_gini <- percent(info[["Gini_before"]] - info[["Gini_after"]])
  names(info) <- c("Ranking","Gini before", "Gini after", "&#916 Gini")
  
  formattable(info, 
              align =c("l","r", "r","r"),
              list(
                'Gini before' = colorbar(color = "lightblue", fun = "percent", digits = 2),
                'Gini after' = colorbar(color = customGreen0, fun = "percent", digits = 2),
                '&#916 Gini' = formatter(
                  "span", x ~ percent(x),
                   style = ~style(color= ifelse( (`Gini after` - `Gini before`) < 0, "green","red"),
                                  
                                  "font-weight" = ifelse((`Gini before` - `Gini after`) > 0,
                                                         ifelse((`Gini before` - `Gini after`) == max(`Gini before` - `Gini after`), "bold",NA), 
                                                         ifelse((`Gini before` - `Gini after`) == min(`Gini before` - `Gini after`),"bold",NA)
                                  )
                  )
              )
              
              ))
}

plot_cdf <- function(df, info) {
  
  hr <- df
  par(mfrow=c(2,4))
  
  for(k in 1:nrow(info)){
    tipo <- info[k,]$tipi
    ss <- hr[ hr$node_placement == tipo,]
    
    grado <- info[k,]$grado
    yy <- sort(ss[[outcome]])
    
    ba <- bern_app2(yy, grado)
    plot(ecdf(yy),xlab="outcome", ylab="CDF", main=paste0("CDF estimation for type ",tipo))
    lines(yy,ba, col="blue", type="b", lty=2,pch = 18)
    legend("topleft", legend=c("ECDF", "Bernstein approx."),
           col=c("black", "blue"), lty=1:2, cex=0.8)
  }
  
}

distributive_rate <- function(df) {
  ### Distributive Rate
  df$distributive_rate <- df[[outcome]] - df$outcome
  df$distributive_rate <- normalize_var(df$distributive_rate,-1,1)
  return(df)
}

stampa_dist_rate <- function(rl) {
  
  for(n in names(rl)){
    rl[[n]]$Ranking <- n
    rl[[n]]$distributive_rate <- rl[[n]][[outcome]] - rl[[n]]$outcome
    rl[[n]]$distributive_rate <- normalize_var(rl[[n]]$distributive_rate,-1,1)
  }
  
  rbl <- rbindlist(rl)
  
  rbl <- ddply(rbl, .(Ranking), summarize,  Outcome_medio=mean(outcome), Distributive_rate_medio=mean(distributive_rate))
  rbl[['Outcome_medio']] <- round(rbl[['Outcome_medio']],3)
  names(rbl) <- c("Ranking","Mean Outcome","Mean Distributive Rate")
  
  formattable(rbl,
              align =c("l","r", "r"), 
              list(`Mean Distributive Rate` = formatter("span", 
                                                        x ~ percent(x), 
                                                        style = x ~ style(color = ifelse(x > 0, "green", "red"))),
                   `Mean Outcome` = color_bar(color = "lightblue", fun=unit.scale)
                   )
              )
}

shannon_diversity <- function(df) {
  n_col <- ncol(df)
  for(col_index in 1:n_col) {
    t <- table(df[,col_index])
    print(diversity(t))
  }
}

stampa_shannon <- function(df) {
  # X
  
  df$node_placement <- NULL
  df$quantile<- NULL
  df$outcome<- NULL
  
  b <- df$Ranking 
  df$Ranking <- NULL
  
  Feature <- names(df)
  
  sh_or <- sapply(df, function(x) diversity(table(x)) )
  
  s1 <- data.frame(Feature,sh_or)
  s1$Dataset <- b[1:nrow(s1)]

  names(s1) <- c("Feature", "Shannon","Dataset")

  ggplot(s1, aes(fill=Dataset, y=Shannon, x=Feature)) + 
    theme(axis.text.x=element_text(angle=90,hjust=1)) +
    geom_bar(position="dodge", stat="identity") + 
    labs(y="Shannon Index", x = "Circumstances")
}

stampa_shannon_compare <- function(df) {
  # X
  
  df$node_placement <- NULL
  df$quantile<- NULL
  df$outcome<- NULL
  
  Feature <- names(df)
  
  x1<-split(df, df$sample)
  sh_or <- sapply(x1$original, function(x) diversity(table(x)) )
  sh_mod <- sapply(x1$modified, function(x) diversity(table(x)) )
  
  s1 <- data.frame(Feature,sh_or)
  s1$Dataset <- "Setting 1"
  
  s2 <- data.frame(Feature,sh_mod)
  s2$Dataset <- "Setting 2"
  
  names(s1) <- c("Feature", "Shannon","Dataset")
  names(s2) <- c("Feature", "Shannon","Dataset")
  
  s <- bind_rows(s1,s2)
  s <- s[s$Feature != "sample",]
  ggplot(s, aes(fill=Dataset, y=Shannon, x=Feature)) + 
    theme(axis.text.x=element_text(angle=90,hjust=1)) +
    geom_bar(position="dodge", stat="identity") + 
    labs(y="Shannon Index", x = "Circumstances")
}

stampa_theil <- function(rl) {
  
  for(n in names(rl)){
    rl[[n]]$Ranking <- n
  }
  
  rbl <- rbindlist(rl)
  rbl <- ddply(rbl, .(Ranking), summarize,  G3=Theil(G3), Outcome=Theil(outcome))

  df2 <- tidyr::pivot_longer(rbl, cols=c('G3', 'Outcome'), names_to='variable', 
                             values_to="Theil")
  
  #df2$Ranking <- factor(df2$Ranking,levels = c("Equity-*", "Equality-*", "Needing-*"))
  
  
  ggplot(df2, aes( x=Ranking, y=Theil, fill=variable)) + 
    geom_bar(position="dodge", stat="identity") + 
    labs(y="Theil Index")
}

theil_entropy <- function(df) {
  Theil(df$outcome)
  Theil(df[[outcome]])
}

stampa_tipi <- function (df) {
  
  tops <- data.frame(xtabs(~Ranking+node_placement, data=df))
  tops <- ddply(tops, .(Ranking), summarize,  Percentage=Freq/sum(Freq)*100, Type = node_placement)

  
  #colnames(tops) <- c("Ranking", "Type", "Frequency", "Percentage")
  
  #tops$Ranking <- factor(tops$Ranking,levels = c("Initial", "Equity-100", "Equality-100", "Needing-100"))
  
  ggplot(tops, aes(fill=Type, y=Percentage, x=Ranking)) + 
    geom_bar(position="dodge", stat="identity") +
    scale_y_continuous(breaks = scales::pretty_breaks(n = 10))
}