clear all
close all

% ***********************   NB   ***********************
%Il programma costruisce la geometria per l'analisi con FEM tramite ANSYS
%del pannello sandwich date le dimensioni. Nella dimensione dello spessore
%del pannello si sviluppa una sola cella.
% ***********************   NB   ***********************
% Il programma definisce i k-points partendo dall'origine del sistema
% di riferimento, prosegue su x (nel senso della lunghezza). Arrivato
% all'estremit del pannello si sposta su z (senso della larghezza) e
% ripete come sopra. L'ultima dimensione su cui si sposta  y (spessore)
% ******************************************************

%Indicare l'indirizzo della cartella in cui salvare il file txt della
%geometria
%ggpath='C:\Users\silvano\Documents\Paolo\Universidad\Masterarbeit zwei\ANSYS_models\Scripts\';
%Definire numero di bordi vincolati (constrained edges). Se due soltanto
%(caso di sandwich beams) i bordi sono agli estremi lungo la x
%beams: c_ed=2; panels: c_ed=4
c_ed=2;
%Definire le dimensioni della cella: x,z base, y altezza
bx=22;
bz=22;
h=11;
%Definire lunghezza x e larghezza z della beam. Lo spessore  pari
%all'altezza della cella
%Ricorda che L=176mm; poi si passa a 2L,3L,[...],8L...
%Multipli della cella altrimenti il programma non parte!
lx=176;
lz=88;
n=lx/bx;
m=lz/bz;
if floor(n)==n && floor(m)==m && (c_ed==2 | c_ed==4)
    %Di seguito matrici dei nomi dei k-points e delle loro coordinate.
    %Nella medesima posizione (i,j,s) delle matrici trovo nome, coordinate
    %x e z del singolo k-point. La matrice dei nomi ha 3 dimensioni per la
    %geometria di un volume. X e Z solo due perch i due pannelli sono
    %perfettamente sovrapposti. y  un vettore poich i pannelli sono piani
    %e paralleli.
    K_NAME=zeros(2*m+1,2*n+1,2);
    X=zeros(2*m+1,2*n+1);%,2);
    y=[-h/2,h/2];
    Z=zeros(2*m+1,2*n+1);%,2);
    s=0;
    for s=1:2
        j=0;
        for j=1:2*n+1
            i=0;
            for i=1:2*m+1
                K_NAME(i,j,s)=5+5*(j-1)+5*(2*n+1)*(i-1)+5*(2*n+1)*(2*m+1)*(s-1);
                if s==1
                    X(i,j,s)=11*(j-1);
                    Z(i,j,s)=11*(i-1);
                end
            end
        end
    end
    %Definisco i k-points su cui si poggeranno i vincoli e che si trovano
    %alle estremit del pannello (senso della lunghezza) a y=0.
    %Definisco i NOMI dei k-points seguendo la logica muovo x poi z
    %C,c="constraint"
    C_K_NAME=zeros(2*m+1,2*n+1);
    C_K_NAME(1,1)=5+K_NAME(2*m+1,2*n+1,2);
    i=0;
    for i=1:2*m+1
        j=0;
        if i==1 && c_ed==2
            C_K_NAME(1,2*n+1)=5+C_K_NAME(1,1);
        elseif i==1 && c_ed==4
            for j=2:2*n+1
                C_K_NAME(i,j)=5+C_K_NAME(i,j-1);
            end
        elseif i==2*m+1 && c_ed==4
            C_K_NAME(i,1)=5+C_K_NAME(i-1,2*n+1);
            for j=2:2*n+1
                C_K_NAME(i,j)=5+C_K_NAME(i,j-1);
            end
        else
            C_K_NAME(i,1)=5+C_K_NAME(i-1,2*n+1);
            C_K_NAME(i,2*n+1)=5+C_K_NAME(i,1);
        end
    end
    %Con sprintf definisco il nome del file txt su cui vado a riportare la
    %geometria. Nel nome vengono specificate dimensioni e numero di celle
    fileID=fopen(sprintf('Panel_GEOMETRY_lbh--%d%d%d_mm3--%d%d%d_cells',lx,lz,h,n,m,1),'w');
    %fileID=fopen([ggpath sprintf('Panel_GEOMETRY_lbh--%d%d%d_mm3--%d%d%d_cells.txt',lx,lz,h,n,m,1)],'w');
    %Cicli per stampare i k-points nel file
    fprintf(fileID,'! K-points dei pannelli\r\n');
    s=0;
    for s=1:2
        i=0;
        for i=1:2*m+1
            j=0;
            for j=1:2*n+1
                fprintf(fileID,'k,%d,%d,%.1f,%d\r\n',K_NAME(i,j,s),X(i,j),y(s),Z(i,j));
            end
        end
    end
    %Cicli per stampare i k-points dei vincoli
    fprintf(fileID,'\r\n! K-points per i vincoli\r\n');
    i=0;
    for i=1:2*m+1
        j=0;
        for j=1:2*n+1
            if C_K_NAME(i,j)>0
                fprintf(fileID,'k,%d,%d,%d,%d\r\n',C_K_NAME(i,j),X(i,j),0,Z(i,j));
            end
        end
    end
    %Cicli per stampare le aree fra k-points dei pannelli
    fprintf(fileID,'\r\n! Aree dei pannelli\r\n');
    s=0;
    for s=1:2
        i=0;
        for i=1:2*m
            j=0;
            for j=1:2*n
                fprintf(fileID,'a,%d,%d,%d,%d\r\n',K_NAME(i,j,s),K_NAME(i,j+1,s),K_NAME(i+1,j+1,s),K_NAME(i+1,j,s));
            end
        end
    end
    %Cicli per stampare le aree di bordo del pannello
    %Le aree di bordo alle estremit secondo il senso x sono sempre
    %presenti; le altre compaiono solo con c_ed=4
    fprintf(fileID,'\r\n! Aree di bordo\r\n');
    j=0;
    for j=1:2*n:2*n+1
        i=0;
        for i=1:2*m
            s=0;
            for s=1:2
                fprintf(fileID,'a,%d,%d,%d,%d\r\n',C_K_NAME(i,j),K_NAME(i,j,s),K_NAME(i+1,j,s),C_K_NAME(i+1,j));
            end
        end
    end
    if c_ed==4
        fprintf(fileID,'\r\n');
        i=0;
        for i=1:2*m:2*m+1
            j=0;
            for j=1:2*n
                for s=1:2
                    fprintf(fileID,'a,%d,%d,%d,%d\r\n',C_K_NAME(i,j),K_NAME(i,j,s),K_NAME(i,j+1,s),C_K_NAME(i,j+1));
                end
            end
        end
    end
    %Cicli per stampare le linee del truss core
    fprintf(fileID,'\r\n! Linee del truss core\r\n');
    s=1;
    i=0;
    for i=1:2:2*m-1
        j=0;
        for j=1:2:2*n-1
            fprintf(fileID,'l,%d,%d\r\n',K_NAME(i,j,s),K_NAME(i+1,j+1,s+1));
            fprintf(fileID,'l,%d,%d\r\n',K_NAME(i+1,j+1,s+1),K_NAME(i,j+2,s));
            fprintf(fileID,'l,%d,%d\r\n',K_NAME(i+2,j,s),K_NAME(i+1,j+1,s+1));
            fprintf(fileID,'l,%d,%d\r\n',K_NAME(i+1,j+1,s+1),K_NAME(i+2,j+2,s));
        end
    end
    %Cicli per stampare le linee verticali di bordo
    if c_ed==2
        fprintf(fileID,'\r\n! Linee verticali di bordo\r\n');
        s=1;
        i=0;
        for i=1:2*m:2*m+1
            j=0;
            for j=3:2:2*n-1
                fprintf(fileID,'l,%d,%d\r\n',K_NAME(i,j,s),K_NAME(i,j,s+1));
            end
        end
    end
    %Fine
    fclose(fileID);
else
    fprintf('\n    ******** ATTENZIONE! ********\n Inserire dimensioni multiple dei valori di cella.\n Scegliere un numero di bordi vincolati fra c_ed=2 e c_ed=4.\n');
end

%Per visualizzare nella command window il file txt
%type (sprintf('Panel_lbh--%d%d%d_mm3--%d%d%d_cells',lx,lz,h,n,m,1))