define( [], function () {
    'use strict';

    // *****************************************************************************
    // Appearance Section
    // *****************************************************************************

    var excelDesc = {
      type: 'string',
      component: 'text',
      label: 'Specify the Excel file path to open and the macro name that will be invoked when WritebackExcel_Export completes an export, receiving the url of the exported file as macro parameter'
    };
	var fileName = {
		ref: "props.excelFileName",
		label: "File to open",
		type: "string"
	};
	var macroName = {
		ref: "props.excelMacroName",
		label: "Macro to execute",
		type: "string"
	};

	var licenceDesc = {
      type: 'string',
      component: 'text',
      label: 'Specify the EDrawSoft ActiveX CAB location'
    };
	//var licenceName = {
	//	ref: "props.licenceName",
	//	label: "Licence name",
	//	type: "string"
	//};
	//var licenceCode = {
	//	ref: "props.licenceCode",
	//	label: "Licence code",
	//	type: "string"
	//};	
	var cabLocation = {
		ref: "props.cabLocation",
		label: "Cab location",
		type: "string"
	};
	// Define a custom section
	var excelSection = {
		// not necessary to define the type, component "expandable-items" will automatically
		// default to "items"
		// type: "items"
		component: "expandable-items",
		label: "Settings",
		items: {
			header1: {
				type: "items",
				label: "Excel",
				items: {
					excelDesc: excelDesc,
					fileName : fileName,
					macroName: macroName
				}
			},
			header2: {
				type: "items",
				label: "ActiveX settings",
				items: {
					licenceDesc: licenceDesc,
					//licenceName: licenceName,
					//licenceCode: licenceCode,
					cabLocation: cabLocation
				}
			}

		}
	}
    // *****************************************************************************
    // Main property panel definition
    // ~~
    // Only what's defined here will be returned from properties.js
    // *****************************************************************************

    return {
        type: "items",
        component: "accordion",
        items: {
            excelSection: excelSection
        }
    };

} );
