define([
	"qlik", 
	"./properties",
	"text!./template.html"
	], function ( qlik, props, template ) {

		return {
   			definition: props,		
			template: template,
			support: {
				snapshot: true,
				export: true,
				exportData: false
			},
			paint: function () {
				return qlik.Promise.resolve();
			},
			controller: ['$scope','$rootScope', function ( $scope, $rootScope ) {
				//add your rendering code here
				$scope.state = {};
				
				var codebase = $scope.layout.props.cabLocation;	
				if(codebase == null || codebase == "")
				{
					//codebase = require.toUrl("extensions/WritebackExcel_Input/activex/edexcel.cab");
					codebase = "activex/edexcel.cab";
				}
				$scope.state.iframeBaseUrl = require.toUrl("extensions/WritebackExcel_Input/excelviewer_frame.html") + "?codebase=" + window.encodeURIComponent(codebase) + "&excel=" + window.encodeURIComponent($scope.layout.props.excelFileName) + "&macro=" + $scope.layout.props.excelMacroName;
				
				$scope.state.iframeUrl = $scope.state.iframeBaseUrl + "";
				
				$scope.state.csvUrl = '';				
				$rootScope.$watch('export', 
					function(newVal, oldVal)
					{
						if(newVal == undefined || newVal == null || newVal.csvUrl == $scope.state.csvUrl)
							return;
						$scope.state.csvUrl = newVal.csvUrl;
						$scope.state.iframeUrl = $scope.state.iframeBaseUrl + "&csv=" + window.encodeURIComponent($scope.state.csvUrl);
					}
					,true);
			}]
		};

	} );

