import cv2
import numpy as np
import os
import sys
import timeit
import datetime
from os.path import isfile, join

def usage():
    print("Wrong argument inserted!")
    print ('Usage: '+ sys.argv[0] + ' <dir_images_file> <fps>')
    print('Example: python images_to_video.py C:/Users/Desktop/CARLA/_out/ 30')
    print('                                                           ^')
    print('                                                           |')
    print('                                 Directory where the CARLA images are')
    
def main(argv):
    
    if ((len(sys.argv) < 3) or len(sys.argv) > 3):
        usage()
        print("Exiting...")
        sys.exit()
    elif len(sys.argv) == 3:
        path = sys.argv[1]
        print(f"""The passed parameter is: {path}""")
        fps = sys.argv[2] # frame per seconds for the destination file video
        # Generate the video from multiple images
        generate_video(path, int(fps))
        
def generate_video(pathIn, fps): 
    """
    ## This function is used to get a video from multiple images using OpenCV library
    """
    output = 'video_out.avi' # destination file name         
    frame_array = []
    # Check extension files
    files = [fra for fra in os.listdir(pathIn) if fra.endswith(".png") and isfile(join(pathIn, fra))]
    flag = True
    
    print('Start converting the images into a video...')
    num_of_images = len(files) 
    print('Total number of images detected: ', num_of_images) 
    
    # Calculates the processing time needed to convert images into a video
    start = timeit.default_timer()
    for i in range(len(files)):
        filename=pathIn + files[i]
        # Reading each image files
        img = cv2.imread(filename)
        if img is None:
            print("Unable to read file. Exiting...")
            sys.exit()
        # Take width and height of frames    
        height, width, layers = img.shape
        size = (width,height)
        if flag:
            print("Video size:", size, "[width x height]")
            flag=False
        
        # Concatenate the image frames into an image array
        frame_array.append(img)
    
    # Create output video file    
    out = cv2.VideoWriter(output,cv2.VideoWriter_fourcc(*'DIVX'), fps, size)
    for i in range(len(frame_array)):
        # writing to a image array -> video
        out.write(frame_array[i])
    
    # Calculate time
    tem = timeit.default_timer() - start
    t = str(datetime.timedelta(seconds=tem)) 
    # Release resource
    out.release()
    print('Conversion from images to video -> Done!')
    print('Total Processing Time: ', t, '[h:m:s]')
    print('\nFile output saved in:', output, 'at fps=', fps)
    
if __name__ =='__main__':
    main(sys.argv[1:])