package eu.europa.ec.healtheid.notification.adapter.service;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;

import eu.europa.ec.healtheid.notification.adapter.model.HealtheidNotification;

@Component
public class HealtheidNotifierImpl implements HealtheidNotifier {

    private static final Logger LOGGER = LoggerFactory.getLogger(HealtheidNotifierImpl.class);

    private JavaMailSender mailSender;
    
    @Value("${email.from}")
    private String emailFrom;

    @Autowired
    public HealtheidNotifierImpl(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    /**
     * This method will send a message based on HealtheidNotification. Will first look for an email and after for an SMS.
     * If the message wasn't successfully send the boolean healtheidNotification.notificationSent will be false.
     *
     * @param healtheidNotification
     * @return HealtheidNotification
     */
    @Override
    public HealtheidNotification notify(HealtheidNotification healtheidNotification) {
        try {
            if (!healtheidNotification.getEmail().isEmpty()) {
                notifyByEmail(healtheidNotification);
            } else {
                if(!healtheidNotification.getSms().isEmpty()){
                    notifyBySMS(healtheidNotification);
                } else  {
                    throw new Exception("Email and SMS blank");
                }
            }
        } catch (Exception e) {
            LOGGER.info("Error sending the notification  " + e.getMessage());
        }
        return healtheidNotification;
    }



    private void notifyByEmail(HealtheidNotification healtheidNotification) throws MessagingException {
        healtheidNotification.setNotificationSent(false);
        MimeMessage message = mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message);

        LOGGER.info("Mime message created");

        LOGGER.info("preparing link...");
        helper.setFrom(emailFrom);
        helper.setTo(healtheidNotification.getEmail());
        helper.setText(healtheidNotification.getMessage());
        helper.setSubject(healtheidNotification.getTitle());

        LOGGER.info("spring.mail.host  " + helper.getMimeMessage().getSession().getProperties());
        
        mailSender.send(message);

        healtheidNotification.setNotificationSent(true);
    }

    private void notifyBySMS(HealtheidNotification healtheidNotification) {
        //TODO: Implement this method

        LOGGER.info("This method is not implemented yet");
        healtheidNotification.setNotificationSent(false);
    }
}
