package eu.europa.ec.healtheid.utils;

import eu.europa.ec.healtheid.models.SearchFieldsForm;
import org.junit.Test;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

public class SearchFieldsFormUtilsTest {

    @Test
    public void prepareForView() {
        SearchFieldsForm searchFieldsForm = new SearchFieldsForm();
        searchFieldsForm.setSex("Male");
        searchFieldsForm.setBirthDate(LocalDate.now().toString());

        Map<String,String> ids = new HashMap<>();
        ids.put("Test 1","Tested 1");
        ids.put("tested2"," testedTwo ");

        Map<String,String> textFields = new HashMap<>();
        textFields.put("Text 1","Text One");
        textFields.put("Text2"," Text2 ");

        searchFieldsForm.setIds(ids);
        searchFieldsForm.setTextFields(textFields);

        SearchFieldsForm sc = SearchFieldsFormUtils.prepareForView(searchFieldsForm);

        assertNull(sc.getIds().get("Test 1"));
        assertEquals(sc.getIds().get("Test_1"), "Tested 1");
        assertEquals(sc.getIds().get("tested2")," testedTwo ");

        assertNull(sc.getTextFields().get("Text 1"));
        assertEquals(sc.getTextFields().get("Text_1"), "Text One");
        assertEquals(sc.getTextFields().get("Text2")," Text2 ");


    }

    @Test
    public void processViewReturn() {
        SearchFieldsForm searchFieldsForm = new SearchFieldsForm();
        searchFieldsForm.setSex("Male");
        searchFieldsForm.setBirthDate(LocalDate.now().toString());

        Map<String,String> ids = new HashMap<>();
        ids.put("Test_1","Tested 1");
        ids.put("tested2"," testedTwo ");

        Map<String,String> textFields = new HashMap<>();
        textFields.put("Text_1","Text One");
        textFields.put("Text2"," Text2 ");

        searchFieldsForm.setIds(ids);
        searchFieldsForm.setTextFields(textFields);

        SearchFieldsForm sc = SearchFieldsFormUtils.processViewReturn(searchFieldsForm);

        assertNull(sc.getIds().get("Test_1"));
        assertEquals(sc.getIds().get("Test 1"), "Tested 1");
        assertEquals(sc.getIds().get("tested2")," testedTwo ");

        assertNull(sc.getTextFields().get("Text_1"));
        assertEquals(sc.getTextFields().get("Text 1"), "Text One");
        assertEquals(sc.getTextFields().get("Text2")," Text2 ");


    }
}
