package eu.europa.ec.healtheid.utils;

import eu.europa.ec.healtheid.models.Encounter;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.util.ReflectionTestUtils;

import static org.junit.Assert.*;

public class JwtTokenUtilsTest {

    private static final String SECRET = "THISISASECRET";
    private static final Long EXPIRATION = 7200L;

    private JwtTokenUtils jwtTokenUtils = new JwtTokenUtils();

    @Before
    public void setup() {
        ReflectionTestUtils.setField(jwtTokenUtils,"secret", SECRET);
        ReflectionTestUtils.setField(jwtTokenUtils,"expiration", EXPIRATION);
    }


    @Test
    public void tokenCreationAndValidation() {
        Encounter encounter = new Encounter();
        encounter.setPatientCountryCode("pt");
        String token = jwtTokenUtils.createToken(encounter);

        assertNotNull(token);

        assertTrue(jwtTokenUtils.validateToken(token));
        assertFalse(jwtTokenUtils.validateToken(token+"invalid"));

        assertEquals(jwtTokenUtils.readCountry(token), "pt");
    }

}
