package eu.europa.ec.healtheid.repository;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Map.Entry;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import eu.europa.ec.healtheid.models.Demographics;
import eu.europa.ec.healtheid.models.Encounter;
import eu.europa.ec.healtheid.models.PatientData;
import eu.europa.ec.healtheid.utils.JwtTokenUtils;

@RunWith(SpringJUnit4ClassRunner.class)
@DataJpaTest
public class PatientDataRepositoryTest {
	
	 @Autowired
	  private PatientDataRepository patientRepository;
	 @Mock
	    JwtTokenUtils jwtTokenUtils;
	 
	 @Test
	    public void store_and_update_PatientData() {
	    	
	    	Encounter encounter = new Encounter();
	    	Mockito.when(jwtTokenUtils.createToken(encounter)).thenReturn("aaa.bbb.ccc");
	        
	    	String encounterID = jwtTokenUtils.createToken(encounter);
	    	
	    	PatientData patient =new PatientData();
	    	patient.setEncounterID(encounterID);
	    	patient.setDataReady(false);    	
	    	patientRepository.save(patient);	
	    			
	    	PatientData p1=patientRepository.findById(encounterID).get();
	    	assertEquals(p1,patient);
	    	
	    	//update patientData 
	    	HashMap <String,String> eidasAttributes=new HashMap<>();
	    	eidasAttributes.put("FamilyName", "John");
	    	eidasAttributes.put("FirstName",  "Snow");
	    	eidasAttributes.put("DateOfBirth",  "02/03/1987");
	    	eidasAttributes.put("PersonIdentifier",  "W1NT3R1SC0M1NG");
	    	eidasAttributes.put("PlaceOfBirth",  "Winterfell");
	    	eidasAttributes.put("TaxReference",  "T4XR3F3R3NC3C0D3");
	    	
	    	for (Entry<String, String> entry : eidasAttributes.entrySet()){
				
				Demographics patientDemographics = new Demographics();
				if(entry.getKey().contentEquals("TaxReference"))
			    	p1.setDataReady(true);
				patientDemographics.setFriendlyName(entry.getKey());
				patientDemographics.setUserValue(entry.getValue());
				patientDemographics.setMandatory(true);
	    	}	
	    	patient=patientRepository.save(p1);
	    	assertTrue("The dataReady has to be set to true",patient.dataIsReady());     	
	    }
	    @Test(expected = NoSuchElementException.class)
	    public void delete_from_PatientDataRepository() {
	    	Encounter encounter = new Encounter();
	    	Mockito.when(jwtTokenUtils.createToken(encounter)).thenReturn("aaa.bbb.ccc");
	        
	    	String encounterID = jwtTokenUtils.createToken(encounter);
	    	
	    	PatientData patient =new PatientData();
	    	patient.setEncounterID(encounterID);
	    	patient.setDataReady(false);
	    	
	    	PatientData p1=patientRepository.save(patient);	
	    	//delete the value
	    	patientRepository.deleteById(p1.getEncounterID());
	    	//try to retrieve deleted value: it will raise an exception
	    	patientRepository.findById(p1.getEncounterID()).get();
	    }
}
